/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import java.util.Collections;
import java.util.Map;
import jenkins.scm.api.SCMUri;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

class SCMUriTest {
    SCMUriTest() {
    }

    @Test
    void given__url_with_custom_scheme__when__normalizing__then__custom_default_port_elided() {
        MatcherAssert.assertThat((Object)SCMUri.normalize((String)"myscm://myscm.EXAMPLE.COM:6352/", (Map[])new Map[]{Collections.singletonMap("myscm", 6352)}), (Matcher)Matchers.is((Object)"myscm://myscm.example.com"));
        MatcherAssert.assertThat((Object)SCMUri.normalize((String)"myscm://myscm.EXAMPLE.COM:6352/"), (Matcher)Matchers.is((Object)"myscm://myscm.example.com:6352"));
    }

    @Test
    void given__url_without_hostname__when__normalizing__then__no_name_inferred() {
        MatcherAssert.assertThat((Object)SCMUri.normalize((String)"FILE:///some/random/file"), (Matcher)Matchers.is((Object)"file:///some/random/file"));
    }

    @Test
    void given__normalized_url__when__normalizing__then__verbatim() {
        MatcherAssert.assertThat((Object)SCMUri.normalize((String)"https://example.com/foo"), (Matcher)Matchers.is((Object)"https://example.com/foo"));
        MatcherAssert.assertThat((Object)SCMUri.normalize((String)"https://example.com:8443/foo"), (Matcher)Matchers.is((Object)"https://example.com:8443/foo"));
        MatcherAssert.assertThat((Object)SCMUri.normalize((String)"https://bob@example.com/foo"), (Matcher)Matchers.is((Object)"https://bob@example.com/foo"));
        MatcherAssert.assertThat((Object)SCMUri.normalize((String)"https://bob:pass@example.com/foo"), (Matcher)Matchers.is((Object)"https://bob:pass@example.com/foo"));
        MatcherAssert.assertThat((Object)SCMUri.normalize((String)"https://bob%25smith@example.com/foo"), (Matcher)Matchers.is((Object)"https://bob%25smith@example.com/foo"));
        MatcherAssert.assertThat((Object)SCMUri.normalize((String)"https://bob%25smith:pass@example.com/foo"), (Matcher)Matchers.is((Object)"https://bob%25smith:pass@example.com/foo"));
    }

    @Test
    void given__url_with_punycode__when__normalizing__then__punycode_retained() {
        MatcherAssert.assertThat((Object)SCMUri.normalize((String)"http://xn--e1afmkfd.xn--p1ai/"), (Matcher)Matchers.is((Object)"http://xn--e1afmkfd.xn--p1ai"));
    }

    @Test
    void given__url_with_idn__when__normalizing__then__hostname_is_decoded() {
        MatcherAssert.assertThat((Object)SCMUri.normalize((String)"http://\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444/"), (Matcher)Matchers.is((Object)"http://xn--e1afmkfd.xn--p1ai"));
    }

    @Test
    void given__url_with_idn_and_port__when__normalizing__then__hostname_is_decoded() {
        MatcherAssert.assertThat((Object)SCMUri.normalize((String)"http://\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444:8080/"), (Matcher)Matchers.is((Object)"http://xn--e1afmkfd.xn--p1ai:8080"));
    }

    @Test
    void given__url_with_user_and_idn__when__normalizing__then__hostname_is_decoded() {
        MatcherAssert.assertThat((Object)SCMUri.normalize((String)"http://bob@\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444:8080/"), (Matcher)Matchers.is((Object)"http://bob@xn--e1afmkfd.xn--p1ai:8080"));
    }

    @Test
    void given__url_with_userpass_and_idn__when__normalizing__then__hostname_is_decoded() {
        MatcherAssert.assertThat((Object)SCMUri.normalize((String)"http://bob:secret@\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444/"), (Matcher)Matchers.is((Object)"http://bob:secret@xn--e1afmkfd.xn--p1ai"));
    }

    @Test
    void given__url_with_userpass_and_idn_and_port__when__normalizing__then__hostname_is_decoded() {
        MatcherAssert.assertThat((Object)SCMUri.normalize((String)"http://bob:secret@\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444:8080/"), (Matcher)Matchers.is((Object)"http://bob:secret@xn--e1afmkfd.xn--p1ai:8080"));
    }

    @Test
    void given__url_with_everything_messed_up__when__normalizing__then__everything_is_fixed() {
        MatcherAssert.assertThat((Object)SCMUri.normalize((String)"HTTPS://b\u00f6b:se\u00e7ret@\u043f\u0440\u0438\u043c\u0435\u0440.\u0440\u0444:\u0e54\u0e54\u0e53/foo/../"), (Matcher)Matchers.is((Object)"https://b%C3%B6b:se%C3%A7ret@xn--e1afmkfd.xn--p1ai"));
    }
}

