/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jenkins.scm.api.SCMCategory;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;
import jenkins.scm.api.mixin.TagSCMHead;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.TagSCMHeadCategory;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import jenkins.util.NonLocalizable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.jvnet.localizer.Localizable;

class SCMCategoryTest {
    SCMCategoryTest() {
    }

    @Test
    void toDisplayName() {
        MatcherAssert.assertThat((Object)SCMCategory.toDisplayName((SCMCategory[])new SCMHeadCategory[]{UncategorizedSCMHeadCategory.DEFAULT, ChangeRequestSCMHeadCategory.DEFAULT, TagSCMHeadCategory.DEFAULT}).toString(Locale.ENGLISH), (Matcher)Matchers.is((Object)"Branches / Change requests / Tags"));
        MatcherAssert.assertThat((Object)SCMCategory.toDisplayName((SCMCategory[])new SCMHeadCategory[]{UncategorizedSCMHeadCategory.DEFAULT, TagSCMHeadCategory.DEFAULT}).toString(Locale.ENGLISH), (Matcher)Matchers.is((Object)"Branches / Tags"));
        MatcherAssert.assertThat((Object)SCMCategory.toDisplayName((SCMCategory[])new UncategorizedSCMHeadCategory[]{UncategorizedSCMHeadCategory.DEFAULT}).toString(Locale.ENGLISH), (Matcher)Matchers.is((Object)"Branches"));
    }

    @Test
    void toDisplayName1() {
        MatcherAssert.assertThat((Object)SCMCategory.toDisplayName(Arrays.asList(ChangeRequestSCMHeadCategory.DEFAULT, TagSCMHeadCategory.DEFAULT, UncategorizedSCMHeadCategory.DEFAULT)).toString(Locale.ENGLISH), (Matcher)Matchers.is((Object)"Branches / Change requests / Tags"));
    }

    @Test
    void toShortUrl() {
        MatcherAssert.assertThat((Object)SCMCategory.toShortUrl((SCMCategory[])new SCMHeadCategory[]{UncategorizedSCMHeadCategory.DEFAULT, ChangeRequestSCMHeadCategory.DEFAULT, TagSCMHeadCategory.DEFAULT}), (Matcher)Matchers.is((Object)"change-requests_default_tags"));
    }

    @Test
    void toShortUrl1() {
        MatcherAssert.assertThat((Object)SCMCategory.toShortUrl(Arrays.asList(ChangeRequestSCMHeadCategory.DEFAULT, TagSCMHeadCategory.DEFAULT, UncategorizedSCMHeadCategory.DEFAULT)), (Matcher)Matchers.is((Object)"change-requests_default_tags"));
        MatcherAssert.assertThat((Object)SCMCategory.toShortUrl(Arrays.asList(TagSCMHeadCategory.DEFAULT, UncategorizedSCMHeadCategory.DEFAULT)), (Matcher)Matchers.is((Object)"default_tags"));
        MatcherAssert.assertThat((Object)SCMCategory.toShortUrl(Collections.singletonList(TagSCMHeadCategory.DEFAULT)), (Matcher)Matchers.is((Object)"tags"));
    }

    @Test
    void group() {
        UncategorizedSCMHeadCategory u1 = UncategorizedSCMHeadCategory.DEFAULT;
        UncategorizedSCMHeadCategory u2 = new UncategorizedSCMHeadCategory((Localizable)new NonLocalizable("foo"));
        ChangeRequestSCMHeadCategory c1 = ChangeRequestSCMHeadCategory.DEFAULT;
        ChangeRequestSCMHeadCategory c2 = new ChangeRequestSCMHeadCategory((Localizable)new NonLocalizable("bar"));
        ChangeRequestSCMHeadCategory c3 = new ChangeRequestSCMHeadCategory((Localizable)new NonLocalizable("manchu"));
        Map result = SCMCategory.group((SCMCategory[])new SCMHeadCategory[]{u1, c1, c2, c3, u2});
        MatcherAssert.assertThat(result.entrySet(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((List)result.get("default")), (Matcher)Matchers.containsInAnyOrder((Object[])new SCMHeadCategory[]{u1, u2}));
        MatcherAssert.assertThat((Object)((List)result.get("change-requests")), (Matcher)Matchers.containsInAnyOrder((Object[])new SCMHeadCategory[]{c1, c2, c3}));
    }

    @Test
    void group1() {
        UncategorizedSCMHeadCategory u1 = UncategorizedSCMHeadCategory.DEFAULT;
        UncategorizedSCMHeadCategory u2 = new UncategorizedSCMHeadCategory((Localizable)new NonLocalizable("foo"));
        ChangeRequestSCMHeadCategory c1 = ChangeRequestSCMHeadCategory.DEFAULT;
        ChangeRequestSCMHeadCategory c2 = new ChangeRequestSCMHeadCategory((Localizable)new NonLocalizable("bar"));
        ChangeRequestSCMHeadCategory c3 = new ChangeRequestSCMHeadCategory((Localizable)new NonLocalizable("manchu"));
        TagSCMHeadCategory t1 = new TagSCMHeadCategory((Localizable)new NonLocalizable("foomanchu"));
        Map result = SCMCategory.group(Arrays.asList(u1, c1, t1, c2, c3, u2));
        MatcherAssert.assertThat(result.entrySet(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)((List)result.get("default")), (Matcher)Matchers.containsInAnyOrder((Object[])new SCMHeadCategory[]{u1, u2}));
        MatcherAssert.assertThat((Object)((List)result.get("change-requests")), (Matcher)Matchers.containsInAnyOrder((Object[])new SCMHeadCategory[]{c1, c2, c3}));
        MatcherAssert.assertThat((Object)((List)result.get("tags")), (Matcher)Matchers.contains((Object[])new SCMHeadCategory[]{t1}));
    }

    @Test
    void getName() {
        MatcherAssert.assertThat((Object)new MySCMCategory("foomanchu", new NonLocalizable("Fu Manchu"), new NonLocalizable("Fu Manchu")).getName(), (Matcher)Matchers.is((Object)"foomanchu"));
    }

    @Test
    void getDisplayName() {
        MatcherAssert.assertThat((Object)new MySCMCategory("foomanchu", new NonLocalizable("Fu Manchu"), new NonLocalizable("Fu Manchu")).getDisplayName().toString(Locale.ENGLISH), (Matcher)Matchers.is((Object)"Fu Manchu"));
    }

    @Test
    void defaultDisplayName() {
        MatcherAssert.assertThat((Object)new MySCMCategory("foomanchu", null, new NonLocalizable("Fu Manchu")).getDisplayName().toString(Locale.ENGLISH), (Matcher)Matchers.is((Object)"Fu Manchu"));
    }

    @Test
    void isMatch() {
        UncategorizedSCMHeadCategory u = UncategorizedSCMHeadCategory.DEFAULT;
        ChangeRequestSCMHeadCategory c = ChangeRequestSCMHeadCategory.DEFAULT;
        TagSCMHeadCategory t = TagSCMHeadCategory.DEFAULT;
        final SCMHead mh = new SCMHead("basic");
        class TagSCMHeadImpl
        extends SCMHead
        implements TagSCMHead {
            public TagSCMHeadImpl(String name) {
                super(name);
            }

            public long getTimestamp() {
                return 0L;
            }
        }
        TagSCMHeadImpl th = new TagSCMHeadImpl("basic");
        class ChangeRequestSCMHeadImpl
        extends SCMHead
        implements ChangeRequestSCMHead {
            final /* synthetic */ SCMCategoryTest this$0;

            public ChangeRequestSCMHeadImpl(String name) {
                this.this$0 = this$0;
                super(name);
            }

            @NonNull
            public String getId() {
                return "mock";
            }

            @NonNull
            public SCMHead getTarget() {
                return mh;
            }
        }
        ChangeRequestSCMHeadImpl ch = new ChangeRequestSCMHeadImpl("basic");
        MatcherAssert.assertThat((Object)u.isMatch((Object)mh, Arrays.asList(u, c, t)), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)u.isMatch((Object)ch, Arrays.asList(c, u, t)), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)u.isMatch((Object)th, Arrays.asList(c, u, t)), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)c.isMatch((Object)mh, Arrays.asList(u, c, t)), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)c.isMatch((Object)ch, Arrays.asList(c, u, t)), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)c.isMatch((Object)th, Arrays.asList(c, u, t)), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)t.isMatch((Object)mh, Arrays.asList(u, c, t)), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)t.isMatch((Object)ch, Arrays.asList(c, u, t)), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)t.isMatch((Object)th, Arrays.asList(c, u, t)), (Matcher)Matchers.is((Object)true));
    }

    private static class MySCMCategory
    extends SCMCategory<Object> {
        private final NonLocalizable defaultDisplayName;

        public MySCMCategory(String name, NonLocalizable displayName, NonLocalizable defaultDisplayName) {
            super(name, (Localizable)displayName);
            this.defaultDisplayName = defaultDisplayName;
        }

        @NonNull
        protected Localizable defaultDisplayName() {
            return this.defaultDisplayName;
        }

        public boolean isMatch(@NonNull Object instance) {
            return instance.hashCode() % 31 == 7;
        }
    }
}

