/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.schedulebuild;

import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParametersDefinitionProperty;
import hudson.util.FormValidation;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jenkins.ui.icon.IconSpec;
import org.jenkinsci.plugins.schedulebuild.Messages;
import org.jenkinsci.plugins.schedulebuild.ScheduleBuildGlobalConfiguration;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ScheduleBuildAction
implements Action,
StaplerProxy,
IconSpec {
    private static final Logger LOGGER = Logger.getLogger(ScheduleBuildAction.class.getName());
    private final Job<?, ?> target;
    private static final long SECURITY_MARGIN = 120L;
    private static final String DATE_TIME_PATTERN = "dd-MM-yyyy HH:mm:ss";
    private static final DateTimeFormatter[] FORMATTERS = new DateTimeFormatter[]{DateTimeFormatter.ofPattern("d-M-y H:m[:s]"), DateTimeFormatter.ofPattern("d-M-y h:m[:s] a", Locale.ROOT)};
    private long quietperiod;

    public ScheduleBuildAction(Job<?, ?> target) {
        this.target = target;
    }

    public Job<?, ?> getOwner() {
        return this.target;
    }

    public String getIconFileName() {
        return null;
    }

    public String getIconClassName() {
        return this.target.hasPermission(Job.BUILD) && this.target.isBuildable() ? "symbol-calendar-outline plugin-ionicons-api" : null;
    }

    public String getDisplayName() {
        return this.target.hasPermission(Job.BUILD) && this.target.isBuildable() ? Messages.ScheduleBuildAction_DisplayName() : null;
    }

    public String getUrlName() {
        return "schedule";
    }

    public boolean schedule(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
        return true;
    }

    public Object getTarget() {
        this.target.checkPermission(Job.BUILD);
        return this;
    }

    public String getDefaultDate() {
        return this.getDefaultDateObject().format(DateTimeFormatter.ofPattern(DATE_TIME_PATTERN));
    }

    public ZonedDateTime getDefaultDateObject() {
        ZonedDateTime zdt = ScheduleBuildGlobalConfiguration.get().getDefaultScheduleTimeObject();
        ZonedDateTime now = ZonedDateTime.now();
        if (now.isAfter(zdt)) {
            zdt = zdt.plusDays(1L);
        }
        return zdt;
    }

    public String getMinDate() {
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime zonedNow = now.withZoneSameInstant(ScheduleBuildGlobalConfiguration.get().getZoneId());
        return zonedNow.format(DateTimeFormatter.ofPattern(DATE_TIME_PATTERN));
    }

    @RequirePOST
    public FormValidation doCheckDate(@QueryParameter String value, @AncestorInPath Item item) {
        ZonedDateTime ddate;
        if (item == null) {
            return FormValidation.ok();
        }
        item.checkPermission(Item.BUILD);
        ZonedDateTime now = ZonedDateTime.now();
        try {
            ddate = this.parseDateTime(value.trim()).atZone(ScheduleBuildGlobalConfiguration.get().getZoneId()).plusSeconds(120L);
        }
        catch (DateTimeParseException ex) {
            return FormValidation.error((String)Messages.ScheduleBuildAction_ParsingError());
        }
        if (now.isAfter(ddate)) {
            return FormValidation.error((String)Messages.ScheduleBuildAction_DateInPastError());
        }
        return FormValidation.ok();
    }

    public long getQuietPeriodInSeconds() {
        return this.quietperiod;
    }

    @RequirePOST
    public HttpResponse doNext(@QueryParameter String date, @AncestorInPath Item item) {
        ZonedDateTime ddate;
        if (item == null) {
            return FormValidation.ok();
        }
        item.checkPermission(Item.BUILD);
        ZonedDateTime now = ZonedDateTime.now();
        String time = date.trim();
        try {
            ddate = this.parseDateTime(time).atZone(ScheduleBuildGlobalConfiguration.get().getZoneId());
        }
        catch (DateTimeParseException ex) {
            LOGGER.log(Level.INFO, ex, () -> "Error parsing " + time);
            return HttpResponses.redirectTo((String)"error");
        }
        this.quietperiod = ChronoUnit.SECONDS.between(now, ddate);
        LOGGER.log(Level.FINER, () -> "Quietperiod: " + this.quietperiod);
        if (this.quietperiod + 120L < 0L) {
            LOGGER.log(Level.INFO, () -> "Error security margin" + this.quietperiod);
            return HttpResponses.redirectTo((String)"error");
        }
        return HttpResponses.forwardToView((Object)this, (String)"redirect");
    }

    private LocalDateTime parseDateTime(String time) {
        DateTimeParseException exception = null;
        for (DateTimeFormatter formatter : FORMATTERS) {
            try {
                return LocalDateTime.parse(time.toUpperCase(Locale.ROOT), formatter);
            }
            catch (DateTimeParseException dtex) {
                exception = dtex;
                LOGGER.log(Level.FINE, dtex, () -> "Did not parse '" + time + "' with formatter " + String.valueOf(formatter));
            }
        }
        throw exception;
    }

    public boolean isJobParameterized() {
        ParametersDefinitionProperty paramDefinitions = (ParametersDefinitionProperty)this.target.getProperty(ParametersDefinitionProperty.class);
        return paramDefinitions != null && paramDefinitions.getParameterDefinitions() != null && paramDefinitions.getParameterDefinitions().size() > 0;
    }

    @Restricted(value={NoExternalUse.class})
    public String getDateTimeFormatting() {
        return DATE_TIME_PATTERN;
    }

    @Restricted(value={NoExternalUse.class})
    public String getTimeZone() {
        return ScheduleBuildGlobalConfiguration.get().getTimeZone();
    }
}

