/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.schedulebuild;

import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.schedulebuild.ScheduledRun;

public class ScheduledRunManager {
    private static final Logger LOGGER = Logger.getLogger(ScheduledRunManager.class.getName());
    private static final Set<ScheduledRun> scheduledRuns = new TreeSet<ScheduledRun>();
    private static boolean loaded = false;

    private ScheduledRunManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addScheduledRun(ScheduledRun scheduledRun) {
        Set<ScheduledRun> set = scheduledRuns;
        synchronized (set) {
            ScheduledRunManager.load();
            scheduledRuns.add(scheduledRun);
            ScheduledRunManager.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeScheduledRun(ScheduledRun scheduledRun) {
        Set<ScheduledRun> set = scheduledRuns;
        synchronized (set) {
            ScheduledRunManager.load();
            scheduledRuns.remove(scheduledRun);
            ScheduledRunManager.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ScheduledRun> getScheduledRuns() {
        Set<ScheduledRun> set = scheduledRuns;
        synchronized (set) {
            ScheduledRunManager.load();
            return new TreeSet<ScheduledRun>(scheduledRuns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeDeletedJobs(String jobName) {
        Set<ScheduledRun> set = scheduledRuns;
        synchronized (set) {
            ScheduledRunManager.load();
            scheduledRuns.removeIf(scheduledRun -> scheduledRun.getJob().equals(jobName));
            ScheduledRunManager.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renameJob(String oldName, String newName) {
        Set<ScheduledRun> set = scheduledRuns;
        synchronized (set) {
            ScheduledRunManager.load();
            for (ScheduledRun scheduledRun : scheduledRuns) {
                if (!scheduledRun.getJob().equals(oldName)) continue;
                scheduledRun.setJob(newName);
            }
            ScheduledRunManager.save();
        }
    }

    private static void save() {
        XmlFile file = new XmlFile(ScheduledRunManager.getFile());
        try {
            file.write(scheduledRuns);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to save scheduled runs to " + String.valueOf(file), e);
        }
    }

    private static void load() {
        if (loaded) {
            return;
        }
        loaded = true;
        File file = ScheduledRunManager.getFile();
        if (!file.exists()) {
            return;
        }
        try {
            XmlFile xmlFile = new XmlFile(file);
            scheduledRuns.addAll((Set)xmlFile.read());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to load scheduled runs from " + String.valueOf(file), e);
        }
    }

    private static File getFile() {
        return new File(Jenkins.get().getRootDir(), "scheduledRuns.xml");
    }

    @Extension
    public static class ScheduleListener
    extends ItemListener {
        public void onDeleted(Item item) {
            ScheduledRunManager.removeDeletedJobs(item.getFullName());
        }

        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            ScheduledRunManager.renameJob(oldFullName, newFullName);
        }
    }
}

