/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.schedulebuild;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.TaskListener;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.schedulebuild.ScheduledBuildCause;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ScheduledRun
implements Serializable,
Comparable<ScheduledRun> {
    private static final long serialVersionUID = 1L;
    private static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss v";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss v");
    private final String id;
    private String job;
    private final ZonedDateTime time;
    private final List<ParameterValue> values;
    private final boolean triggerOnMissed;
    private final ScheduledBuildCause cause;

    public ScheduledRun(String id, String job, ZonedDateTime time, @NonNull List<ParameterValue> values, boolean triggerOnMissed, ScheduledBuildCause cause) {
        this.id = id;
        this.time = time;
        this.values = values;
        this.triggerOnMissed = triggerOnMissed;
        this.job = job;
        this.cause = cause;
    }

    public String getId() {
        return this.id;
    }

    public ZonedDateTime getTime() {
        return this.time;
    }

    public String getFormattedTime() {
        return DATE_TIME_FORMATTER.format(this.time);
    }

    public boolean isTriggerOnMissed() {
        return this.triggerOnMissed;
    }

    public List<ParameterValue> getValues() {
        return this.values;
    }

    public Cause getCause() {
        return this.cause;
    }

    public String getJob() {
        return this.job;
    }

    public void setJob(String job) {
        this.job = job;
    }

    public void run(TaskListener listener, int delay) {
        Job j = (Job)Jenkins.get().getItemByFullName(this.job, Job.class);
        if (j != null) {
            this.run(j, delay);
        } else if (listener != null) {
            listener.error("Job " + this.job + " not found, cannot schedule build");
        }
    }

    public String getParametersTooltip() {
        StringBuilder sb = new StringBuilder();
        sb.append("Build Parameters:");
        for (ParameterValue v : this.values) {
            sb.append("\n");
            sb.append(v.getName()).append("=").append(v.getValue());
        }
        return sb.toString();
    }

    public void run(Job<?, ?> job, int delay) {
        ParametersDefinitionProperty pp = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
        ArrayList<Object> actions = new ArrayList<Object>();
        if (this.cause != null) {
            actions.add(new CauseAction((Cause)this.cause));
        }
        if (pp != null) {
            actions.add(new ParametersAction(this.values));
        }
        ParameterizedJobMixIn.scheduleBuild2(job, (int)delay, (Action[])actions.toArray(new Action[0]));
    }

    @Override
    public int compareTo(ScheduledRun o) {
        int c = this.time.compareTo(o.time);
        if (c != 0) {
            return c;
        }
        return this.id.compareTo(o.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScheduledRun other = (ScheduledRun)obj;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

