// CHECKSTYLE:OFF

package org.jenkinsci.plugins.schedulebuild;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ScheduleBuildAction.DisplayName}: {@code Schedule Build}.
     * 
     * @return
     *     {@code Schedule Build}
     */
    public static String ScheduleBuildAction_DisplayName() {
        return holder.format("ScheduleBuildAction.DisplayName");
    }

    /**
     * Key {@code ScheduleBuildAction.DisplayName}: {@code Schedule Build}.
     * 
     * @return
     *     {@code Schedule Build}
     */
    public static Localizable _ScheduleBuildAction_DisplayName() {
        return new Localizable(holder, "ScheduleBuildAction.DisplayName");
    }

    /**
     * Key {@code ScheduleBuildButtonColumn.DisplayName}: {@code Schedule
     * Build}.
     * 
     * @return
     *     {@code Schedule Build}
     */
    public static String ScheduleBuildButtonColumn_DisplayName() {
        return holder.format("ScheduleBuildButtonColumn.DisplayName");
    }

    /**
     * Key {@code ScheduleBuildButtonColumn.DisplayName}: {@code Schedule
     * Build}.
     * 
     * @return
     *     {@code Schedule Build}
     */
    public static Localizable _ScheduleBuildButtonColumn_DisplayName() {
        return new Localizable(holder, "ScheduleBuildButtonColumn.DisplayName");
    }

    /**
     * Key {@code ScheduleBuildAction.ParsingError}: {@code Not a valid build
     * time}.
     * 
     * @return
     *     {@code Not a valid build time}
     */
    public static String ScheduleBuildAction_ParsingError() {
        return holder.format("ScheduleBuildAction.ParsingError");
    }

    /**
     * Key {@code ScheduleBuildAction.ParsingError}: {@code Not a valid build
     * time}.
     * 
     * @return
     *     {@code Not a valid build time}
     */
    public static Localizable _ScheduleBuildAction_ParsingError() {
        return new Localizable(holder, "ScheduleBuildAction.ParsingError");
    }

    /**
     * Key {@code ScheduleBuildGlobalConfiguration.TimeZoneError}: {@code Not
     * a valid time zone}.
     * 
     * @return
     *     {@code Not a valid time zone}
     */
    public static String ScheduleBuildGlobalConfiguration_TimeZoneError() {
        return holder.format("ScheduleBuildGlobalConfiguration.TimeZoneError");
    }

    /**
     * Key {@code ScheduleBuildGlobalConfiguration.TimeZoneError}: {@code Not
     * a valid time zone}.
     * 
     * @return
     *     {@code Not a valid time zone}
     */
    public static Localizable _ScheduleBuildGlobalConfiguration_TimeZoneError() {
        return new Localizable(holder, "ScheduleBuildGlobalConfiguration.TimeZoneError");
    }

    /**
     * Key {@code ScheduleBuildAction.DateInPastError}: {@code Build cannot
     * be scheduled in the past}.
     * 
     * @return
     *     {@code Build cannot be scheduled in the past}
     */
    public static String ScheduleBuildAction_DateInPastError() {
        return holder.format("ScheduleBuildAction.DateInPastError");
    }

    /**
     * Key {@code ScheduleBuildAction.DateInPastError}: {@code Build cannot
     * be scheduled in the past}.
     * 
     * @return
     *     {@code Build cannot be scheduled in the past}
     */
    public static Localizable _ScheduleBuildAction_DateInPastError() {
        return new Localizable(holder, "ScheduleBuildAction.DateInPastError");
    }

    /**
     * Key {@code ScheduleBuildGlobalConfiguration.ParsingError}: {@code Not
     * a valid build time}.
     * 
     * @return
     *     {@code Not a valid build time}
     */
    public static String ScheduleBuildGlobalConfiguration_ParsingError() {
        return holder.format("ScheduleBuildGlobalConfiguration.ParsingError");
    }

    /**
     * Key {@code ScheduleBuildGlobalConfiguration.ParsingError}: {@code Not
     * a valid build time}.
     * 
     * @return
     *     {@code Not a valid build time}
     */
    public static Localizable _ScheduleBuildGlobalConfiguration_ParsingError() {
        return new Localizable(holder, "ScheduleBuildGlobalConfiguration.ParsingError");
    }

    /**
     * Key {@code ScheduleBuildAction.BadgeTooltip}: {@code {0, choice,0#No
     * builds are|1#1 Build is|1<{0} Builds are} scheduled.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0, choice,0#No builds are|1#1 Build is|1<{0} Builds are}
     *     scheduled.}
     */
    public static String ScheduleBuildAction_BadgeTooltip(Object arg0) {
        return holder.format("ScheduleBuildAction.BadgeTooltip", arg0);
    }

    /**
     * Key {@code ScheduleBuildAction.BadgeTooltip}: {@code {0, choice,0#No
     * builds are|1#1 Build is|1<{0} Builds are} scheduled.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0, choice,0#No builds are|1#1 Build is|1<{0} Builds are}
     *     scheduled.}
     */
    public static Localizable _ScheduleBuildAction_BadgeTooltip(Object arg0) {
        return new Localizable(holder, "ScheduleBuildAction.BadgeTooltip", arg0);
    }

}
