/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.EnvironmentSpecific;
import hudson.model.JDK;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tools.DownloadFromUrlInstaller;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SbtPluginBuilder
extends Builder {
    public static final Logger LOGGER = Logger.getLogger(SbtPluginBuilder.class.getName());
    private final String name;
    private final String jvmFlags;
    private final String sbtFlags;
    private final String actions;
    private String subdirPath;

    @DataBoundConstructor
    public SbtPluginBuilder(String name, String jvmFlags, String sbtFlags, String actions, String subdirPath) {
        this.name = name;
        this.jvmFlags = jvmFlags;
        this.sbtFlags = sbtFlags;
        this.actions = actions;
        this.subdirPath = subdirPath;
    }

    public String getName() {
        return this.name;
    }

    public String getJvmFlags() {
        return this.jvmFlags;
    }

    public String getSbtFlags() {
        return this.sbtFlags;
    }

    public String getActions() {
        return this.actions;
    }

    public String getSubdirPath() {
        return this.subdirPath;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        EnvVars env = null;
        FilePath workDir = build.getModuleRoot();
        try {
            int exitValue;
            ArgumentListBuilder cmdLine = this.buildCmdLine(build, launcher, listener);
            String[] cmds = cmdLine.toCommandArray();
            env = build.getEnvironment((TaskListener)listener);
            env.overrideAll(build.getBuildVariables());
            if (this.subdirPath != null && this.subdirPath.length() > 0) {
                String subSubdirPath = new StrSubstitutor((Map)env).replace(this.subdirPath);
                workDir = new FilePath(workDir, subSubdirPath);
            }
            boolean success = (exitValue = launcher.launch().cmds(cmds).envs((Map)env).stdout((TaskListener)listener).pwd(workDir).join()) == 0;
            build.setResult(success ? Result.SUCCESS : Result.FAILURE);
            return success;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(listener.fatalError("command execution failed: " + e.getMessage()));
            build.setResult(Result.FAILURE);
            return false;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed: " + e.getMessage()));
            build.setResult(Result.FAILURE);
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.fatalError("command execution failed: " + e.getMessage()));
            build.setResult(Result.ABORTED);
            return false;
        }
    }

    private ArgumentListBuilder buildCmdLine(AbstractBuild build, Launcher launcher, BuildListener listener) throws IllegalArgumentException, InterruptedException, IOException {
        String argsToSplit;
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.overrideAll(build.getBuildVariables());
        SbtInstallation sbt = this.getSbt();
        if (sbt == null) {
            throw new IllegalArgumentException("sbt-launch.jar not found");
        }
        sbt = sbt.forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
        String launcherPath = (sbt = sbt.forEnvironment(env)).getSbtLaunchJar(launcher);
        if (launcherPath == null) {
            throw new IllegalArgumentException("sbt-launch.jar not found");
        }
        if (!launcher.isUnix()) {
            args.add(new String[]{"cmd.exe", "/C"});
            args.add("\"");
        }
        JDK jdk = build.getProject().getJDK();
        Computer computer = Computer.currentComputer();
        if (computer != null && jdk != null) {
            jdk = jdk.forNode(computer.getNode(), (TaskListener)listener);
        }
        Object javaExePath = jdk != null ? jdk.getHome() + "/bin/java" : "java";
        args.add((String)javaExePath);
        this.splitAndAddArgs(env.expand(this.jvmFlags), args);
        this.splitAndAddArgs(env.expand(sbt.getSbtArguments()), args);
        this.splitAndAddArgs(env.expand(this.sbtFlags), args);
        FilePath sbtopts = build.getProject().getWorkspace().child(".sbtopts");
        if (sbtopts.exists() && !StringUtils.isBlank((String)(argsToSplit = sbtopts.readToString()))) {
            String[] split;
            for (String flag : split = argsToSplit.split("\\s+")) {
                if (flag.startsWith("-J")) {
                    args.add(flag.substring(2));
                    continue;
                }
                args.add(flag);
            }
        }
        args.add("-jar");
        args.add(launcherPath);
        String subActions = new StrSubstitutor((Map)env).replace(this.actions);
        for (String action : this.split(subActions)) {
            args.add(action);
        }
        if (!launcher.isUnix()) {
            args.add("\"");
        }
        return args;
    }

    private SbtInstallation getSbt() {
        for (SbtInstallation sbtInstallation : this.getDescriptor().getInstallations()) {
            if (this.name == null || !this.name.equals(sbtInstallation.getName())) continue;
            return sbtInstallation;
        }
        return null;
    }

    private void splitAndAddArgs(String argsToSplit, ArgumentListBuilder args) {
        String[] split;
        if (StringUtils.isBlank((String)argsToSplit)) {
            return;
        }
        for (String flag : split = argsToSplit.split("\\s+")) {
            args.add(flag);
        }
    }

    private List<String> split(String s) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'").matcher(s);
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                result.add(matcher.group(1));
                continue;
            }
            if (matcher.group(2) != null) {
                result.add(matcher.group(2));
                continue;
            }
            result.add(matcher.group());
        }
        return result;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static final class SbtInstallation
    extends ToolInstallation
    implements EnvironmentSpecific<SbtInstallation>,
    NodeSpecific<SbtInstallation>,
    Serializable {
        private static final long serialVersionUID = -2281774135009218882L;
        private String sbtLaunchJar;
        private String sbtArguments;

        @DataBoundConstructor
        public SbtInstallation(String name, String home, String sbtArguments, List<? extends ToolProperty<?>> properties) {
            super(name, SbtInstallation.launderHome(home), properties);
            this.sbtArguments = sbtArguments;
            LOGGER.fine("got sbtArguments config: " + sbtArguments);
        }

        private static String launderHome(String home) {
            if (home != null && (home.endsWith("/") || home.endsWith("\\"))) {
                return home.substring(0, home.length() - 1);
            }
            return home;
        }

        public String getSbtLaunchJar(Launcher launcher) throws IOException, InterruptedException {
            return (String)launcher.getChannel().call((Callable)new GetLaunchPathOrHome());
        }

        private File getSbtLaunchJarFile() {
            String home = Util.replaceMacro((String)this.getHome(), (Map)EnvVars.masterEnvVars);
            return new File(home, "bin/sbt-launch.jar");
        }

        public SbtInstallation forEnvironment(EnvVars environment) {
            return new SbtInstallation(this.getName(), environment.expand(this.getHome()), this.sbtArguments, this.getProperties().toList());
        }

        public SbtInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
            return new SbtInstallation(this.getName(), this.translateFor(node, log), this.sbtArguments, this.getProperties().toList());
        }

        public void buildEnvVars(EnvVars env) {
            String home = this.getHome();
            if (home == null) {
                return;
            }
            env.put("PATH+SBT", home + "/bin");
        }

        public String getSbtArguments() {
            return this.sbtArguments;
        }

        private class GetLaunchPathOrHome
        implements Callable<String, IOException> {
            private GetLaunchPathOrHome() {
            }

            public String call() throws IOException {
                File sbtLaunchJarFile = SbtInstallation.this.getSbtLaunchJarFile();
                if (sbtLaunchJarFile.exists()) {
                    return sbtLaunchJarFile.getPath();
                }
                return SbtInstallation.this.getHome();
            }

            public void checkRoles(RoleChecker checker) throws SecurityException {
            }
        }

        @Extension
        @Symbol(value={"sbt"})
        public static class DescriptorImpl
        extends ToolDescriptor<SbtInstallation> {
            public SbtInstallation[] getInstallations() {
                return ((org.jvnet.hudson.plugins.SbtPluginBuilder$DescriptorImpl)Jenkins.get().getDescriptorByType(org.jvnet.hudson.plugins.SbtPluginBuilder$DescriptorImpl.class)).getInstallations();
            }

            public void setInstallations(SbtInstallation ... installations) {
                ((org.jvnet.hudson.plugins.SbtPluginBuilder$DescriptorImpl)Jenkins.get().getDescriptorByType(org.jvnet.hudson.plugins.SbtPluginBuilder$DescriptorImpl.class)).setInstallations(installations);
            }

            public List<? extends ToolInstaller> getDefaultInstallers() {
                return Collections.singletonList(new SbtInstaller(null));
            }

            public String getDisplayName() {
                return "Sbt";
            }

            public FormValidation doCheckHome(@QueryParameter File value) {
                if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                    return FormValidation.ok();
                }
                if (value.getPath().equals("")) {
                    return FormValidation.ok();
                }
                if (!value.exists() || !value.isFile()) {
                    return FormValidation.error((String)"sbt-launch.jar not found");
                }
                return FormValidation.ok();
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private volatile SbtInstallation[] installations = new SbtInstallation[0];

        public DescriptorImpl() {
            super(SbtPluginBuilder.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Build using sbt";
        }

        public SbtInstallation.DescriptorImpl getToolDescriptor() {
            return (SbtInstallation.DescriptorImpl)((Object)ToolInstallation.all().get(SbtInstallation.DescriptorImpl.class));
        }

        public SbtInstallation[] getInstallations() {
            return this.installations;
        }

        public void setInstallations(SbtInstallation ... sbtInstallations) {
            this.installations = sbtInstallations;
            this.save();
        }
    }

    public static class SbtInstaller
    extends DownloadFromUrlInstaller {
        @DataBoundConstructor
        public SbtInstaller(String id) {
            super(id);
        }

        @Extension
        public static final class DescriptorImpl
        extends DownloadFromUrlInstaller.DescriptorImpl<SbtInstaller> {
            public String getDisplayName() {
                return "Install from scala-sbt.org";
            }

            public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
                return toolType == SbtInstallation.class;
            }
        }
    }
}

