/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml.user;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.security.SecurityRealm;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.SecurityListener;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.time.FastDateFormat;
import org.jenkinsci.plugins.saml.SamlSecurityRealm;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.core.Authentication;

public class LoginDetailsProperty
extends UserProperty {
    private static final Logger LOG = Logger.getLogger(LoginDetailsProperty.class.getName());
    private static final String ISO_8601 = "yyyy-MM-dd'T'HH:mm:ssZ";
    private long createTimestamp;
    private long lastLoginTimestamp;
    private long loginCount;

    @DataBoundConstructor
    public LoginDetailsProperty() {
    }

    public static LoginDetailsProperty currentUserLoginDetails() {
        User user = User.current();
        LoginDetailsProperty loginDetails = null;
        if (user != null && user.getProperty(LoginDetailsProperty.class) != null) {
            loginDetails = (LoginDetailsProperty)user.getProperty(LoginDetailsProperty.class);
        }
        return loginDetails;
    }

    public static void currentUserSetLoginDetails() {
        User user = User.current();
        if (user != null && user.getProperty(LoginDetailsProperty.class) != null) {
            LoginDetailsProperty loginDetails = (LoginDetailsProperty)user.getProperty(LoginDetailsProperty.class);
            loginDetails.update();
        }
    }

    public void update() {
        long now = System.currentTimeMillis();
        if (this.getCreateTimestamp() == 0L) {
            this.setCreateTimestamp(now);
        }
        this.setLastLoginTimestamp(now);
        this.setLoginCount(this.getLoginCount() + 1L);
        try {
            this.user.save();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public long getLastLoginTimestamp() {
        return this.lastLoginTimestamp;
    }

    public String getCreateDate() {
        return FastDateFormat.getInstance((String)ISO_8601).format(new Date(this.createTimestamp));
    }

    public String getLastLoginDate() {
        return FastDateFormat.getInstance((String)ISO_8601).format(new Date(this.lastLoginTimestamp));
    }

    public long getLoginCount() {
        return this.loginCount;
    }

    public void setCreateTimestamp(long createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public void setLastLoginTimestamp(long lastLoginTimestamp) {
        this.lastLoginTimestamp = lastLoginTimestamp;
    }

    public void setLoginCount(long loginCount) {
        this.loginCount = loginCount;
    }

    public UserProperty reconfigure(StaplerRequest2 req, JSONObject form) {
        return this;
    }

    @Extension
    public static final class DescriptorImpl
    extends UserPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return "User Login Properties";
        }

        public LoginDetailsProperty newInstance(User user) {
            return new LoginDetailsProperty();
        }

        public boolean isEnabled() {
            return Jenkins.get().getSecurityRealm() instanceof SamlSecurityRealm;
        }
    }

    @Extension
    public static class SecurityListenerImpl
    extends SecurityListener {
        protected void loggedIn(@NonNull String username) {
            SecurityRealm realm = Jenkins.get().getSecurityRealm();
            if (!(realm instanceof SamlSecurityRealm)) {
                return;
            }
            try {
                User u = User.getById((String)username, (boolean)true);
                LoginDetailsProperty o = (LoginDetailsProperty)u.getProperty(LoginDetailsProperty.class);
                if (o == null) {
                    o = new LoginDetailsProperty();
                }
                u.addProperty((UserProperty)o);
                Authentication a = Jenkins.getAuthentication2();
                if (a.getName().equals(username)) {
                    o.update();
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Failed to record granted authorities", e);
            }
        }
    }
}

