/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException2;
import hudson.tasks.Mailer;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.SecurityListener;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.saml.IdpMetadataConfiguration;
import org.jenkinsci.plugins.saml.SamlAdvancedConfiguration;
import org.jenkinsci.plugins.saml.SamlAuthenticationToken;
import org.jenkinsci.plugins.saml.SamlEncryptionData;
import org.jenkinsci.plugins.saml.SamlFormValidation;
import org.jenkinsci.plugins.saml.SamlGroupDetails;
import org.jenkinsci.plugins.saml.SamlPluginConfig;
import org.jenkinsci.plugins.saml.SamlProfileWrapper;
import org.jenkinsci.plugins.saml.SamlProperty;
import org.jenkinsci.plugins.saml.SamlPropertyDescriptor;
import org.jenkinsci.plugins.saml.SamlRedirectActionWrapper;
import org.jenkinsci.plugins.saml.SamlSPMetadataWrapper;
import org.jenkinsci.plugins.saml.SamlUserDetails;
import org.jenkinsci.plugins.saml.SamlUserDetailsService;
import org.jenkinsci.plugins.saml.conf.Attribute;
import org.jenkinsci.plugins.saml.conf.AttributeEntry;
import org.jenkinsci.plugins.saml.user.SamlCustomProperty;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.pac4j.core.exception.http.FoundAction;
import org.pac4j.core.exception.http.OkAction;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.exception.http.SeeOtherAction;
import org.pac4j.core.exception.http.WithLocationAction;
import org.pac4j.saml.profile.SAML2Profile;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class SamlSecurityRealm
extends SecurityRealm {
    public static final String DEFAULT_DISPLAY_NAME_ATTRIBUTE_NAME = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name";
    public static final String DEFAULT_GROUPS_ATTRIBUTE_NAME = "http://schemas.xmlsoap.org/claims/Group";
    public static final int DEFAULT_MAXIMUM_AUTHENTICATION_LIFETIME = 86400;
    public static final String DEFAULT_USERNAME_CASE_CONVERSION = "none";
    public static final String SP_METADATA_FILE_NAME = "saml-sp-metadata.xml";
    public static final String IDP_METADATA_FILE_NAME = "saml-idp-metadata.xml";
    public static final String ERROR_ONLY_SPACES_FIELD_VALUE = "The field should have a value different than spaces";
    public static final String ERROR_NOT_VALID_NUMBER = "The field should be a number greater than 0 and lower than 2147483647.";
    public static final String ERROR_MALFORMED_URL = "The url is malformed.";
    public static final String ERROR_IDP_METADATA_EMPTY = "The IdP Metadata can not be empty.";
    public static final String WARN_RECOMMENDED_TO_SET_THE_GROUPS_ATTRIBUTE = "It is recommended to set the groups attribute.";
    public static final String WARN_RECOMMENDED_TO_SET_THE_USERNAME_ATTRIBUTE = "It is recommended to set the username attribute.";
    public static final String WARN_RECOMMENDED_TO_SET_THE_EMAIL_ATTRIBUTE = "It is recommended to set the email attribute.";
    public static final String ERROR_NOT_POSSIBLE_TO_READ_KS_FILE = "It is not possible to read the keystore file.";
    public static final String ERROR_CERTIFICATES_COULD_NOT_BE_LOADED = "Any of the certificates in the keystore could not be loaded";
    public static final String ERROR_ALGORITHM_CANNOT_BE_FOUND = "the algorithm used to check the integrity of the keystore cannot be found";
    public static final String ERROR_NO_PROVIDER_SUPPORTS_A_KS_SPI_IMPL = "No Provider supports a KeyStoreSpi implementation for the specified type.";
    public static final String ERROR_WRONG_INFO_OR_PASSWORD = "The entry is a PrivateKeyEntry or SecretKeyEntry and the specified protParam does not contain the information needed to recover the key (e.g. wrong password)";
    public static final String ERROR_INSUFFICIENT_OR_INVALID_INFO = "The specified protParam were insufficient or invalid";
    public static final String CONSUMER_SERVICE_URL_PATH = "securityRealm/finishLogin";
    private static final Logger LOG = Logger.getLogger(SamlSecurityRealm.class.getName());
    public static final String WARN_THERE_IS_NOT_KEY_STORE = "There is not keyStore to validate";
    public static final String ERROR_NOT_KEY_FOUND = "Not key found";
    public static final String SUCCESS = "Success";
    public static final String NOT_POSSIBLE_TO_GET_THE_METADATA = "Was not possible to get the Metadata from the URL ";
    public static final String CHECK_TROUBLESHOOTING_GUIDE = "\nIf you have issues check the troubleshoting guide at https://github.com/jenkinsci/saml-plugin/blob/master/doc/TROUBLESHOOTING.md";
    public static final String CHECK_MAX_AUTH_LIFETIME = "\nFor more info check 'Maximum Authentication Lifetime' at https://github.com/jenkinsci/saml-plugin/blob/master/doc/CONFIGURE.md#configuring-plugin-settings";
    public static final String WARN_KEYSTORE_NOT_SET = "Keystore is not set";
    public static final String WARN_PRIVATE_KEY_ALIAS_NOT_SET = "Key alias is not set";
    public static final String WARN_PRIVATE_KEYSTORE_PASS_NOT_SET = "Keystore password is not set";
    public static final String WARN_PRIVATE_KEY_PASS_NOT_SET = "Key password is not set";
    private String displayNameAttributeName;
    private String groupsAttributeName;
    private int maximumAuthenticationLifetime;
    private String emailAttributeName;
    private final String usernameCaseConversion;
    private final String usernameAttributeName;
    private final String logoutUrl;
    private String binding;
    private final SamlEncryptionData encryptionData;
    private final SamlAdvancedConfiguration advancedConfiguration;
    private final IdpMetadataConfiguration idpMetadataConfiguration;
    private List<AttributeEntry> samlCustomAttributes;
    private DescribableList<SamlProperty, SamlPropertyDescriptor> properties = new DescribableList(Saveable.NOOP);

    @DataBoundConstructor
    public SamlSecurityRealm(IdpMetadataConfiguration idpMetadataConfiguration, String displayNameAttributeName, String groupsAttributeName, Integer maximumAuthenticationLifetime, String usernameAttributeName, String emailAttributeName, String logoutUrl, SamlAdvancedConfiguration advancedConfiguration, SamlEncryptionData encryptionData, String usernameCaseConversion, String binding, List<AttributeEntry> samlCustomAttributes) throws IOException {
        this.idpMetadataConfiguration = idpMetadataConfiguration;
        this.usernameAttributeName = Util.fixEmptyAndTrim((String)usernameAttributeName);
        this.usernameCaseConversion = (String)StringUtils.defaultIfBlank((CharSequence)usernameCaseConversion, (CharSequence)DEFAULT_USERNAME_CASE_CONVERSION);
        this.logoutUrl = Util.fixEmptyAndTrim((String)logoutUrl);
        this.displayNameAttributeName = DEFAULT_DISPLAY_NAME_ATTRIBUTE_NAME;
        this.groupsAttributeName = DEFAULT_GROUPS_ATTRIBUTE_NAME;
        this.maximumAuthenticationLifetime = 86400;
        if (displayNameAttributeName != null && !displayNameAttributeName.isEmpty()) {
            this.displayNameAttributeName = displayNameAttributeName;
        }
        if (groupsAttributeName != null && !groupsAttributeName.isEmpty()) {
            this.groupsAttributeName = groupsAttributeName;
        }
        if (maximumAuthenticationLifetime != null && maximumAuthenticationLifetime > 0) {
            this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
        }
        if (StringUtils.isNotBlank((CharSequence)emailAttributeName)) {
            this.emailAttributeName = Util.fixEmptyAndTrim((String)emailAttributeName);
        }
        this.advancedConfiguration = advancedConfiguration;
        this.encryptionData = encryptionData;
        this.binding = binding;
        this.samlCustomAttributes = samlCustomAttributes;
        this.idpMetadataConfiguration.createIdPMetadataFile();
        LOG.finer(this.toString());
    }

    public Object readResolve() {
        File idpMetadataFile = new File(SamlSecurityRealm.getIDPMetadataFilePath());
        if (!idpMetadataFile.exists() && this.idpMetadataConfiguration != null) {
            try {
                this.idpMetadataConfiguration.createIdPMetadataFile();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.getBinding())) {
            this.binding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
        }
        if (this.properties == null) {
            this.properties = new DescribableList(Saveable.NOOP);
        }
        return this;
    }

    public List<SamlProperty> getProperties() {
        return this.properties;
    }

    @DataBoundSetter
    public void setProperties(@CheckForNull List<SamlProperty> properties) throws IOException {
        if (properties != null) {
            this.properties.replaceBy(properties);
        } else {
            this.properties.replaceBy(List.of());
        }
    }

    public boolean allowsSignup() {
        return false;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        LOG.finer("createSecurityComponents");
        return new SecurityRealm.SecurityComponents(authentication -> {
            if (authentication instanceof SamlAuthenticationToken) {
                return authentication;
            }
            throw new BadCredentialsException("Unexpected authentication type: " + String.valueOf(authentication));
        }, (UserDetailsService)new SamlUserDetailsService());
    }

    public String getLoginUrl() {
        return "securityRealm/commenceLogin";
    }

    public HttpResponse doCommenceLogin(StaplerRequest2 request, StaplerResponse2 response) {
        LOG.fine("SamlSecurityRealm.doCommenceLogin called. Using consumerServiceUrl " + this.getSamlPluginConfig().getConsumerServiceUrl());
        RedirectionAction action = (RedirectionAction)new SamlRedirectActionWrapper(this.getSamlPluginConfig(), request, response).get();
        if (action instanceof SeeOtherAction || action instanceof FoundAction) {
            LOG.fine("REDIRECT : " + ((WithLocationAction)action).getLocation());
            return HttpResponses.redirectTo((String)((WithLocationAction)action).getLocation());
        }
        if (action instanceof OkAction) {
            LOG.fine("SUCCESS : " + ((OkAction)action).getContent());
            return HttpResponses.literalHtml((String)((OkAction)action).getContent());
        }
        throw new IllegalStateException("Received unexpected response type " + action.getCode());
    }

    @RequirePOST
    public HttpResponse doFinishLogin(StaplerRequest2 request, StaplerResponse2 response) {
        SAML2Profile saml2Profile;
        LOG.finer("SamlSecurityRealm.doFinishLogin called");
        String redirectUrl = null;
        this.recreateSession(request);
        this.logSamlResponse(request);
        boolean saveUser = false;
        try {
            SamlProfileWrapper samlProfileWrapper = new SamlProfileWrapper(this.getSamlPluginConfig(), request, response);
            saml2Profile = (SAML2Profile)samlProfileWrapper.get();
            redirectUrl = samlProfileWrapper.getRedirectUrl();
        }
        catch (BadCredentialsException e) {
            LOG.log(Level.WARNING, "Unable to validate the SAML Response: " + e.getMessage() + "\nFor more info check 'Maximum Authentication Lifetime' at https://github.com/jenkinsci/saml-plugin/blob/master/doc/CONFIGURE.md#configuring-plugin-settings\nIf you have issues check the troubleshoting guide at https://github.com/jenkinsci/saml-plugin/blob/master/doc/TROUBLESHOOTING.md", e);
            return HttpResponses.redirectTo((String)this.getEffectiveLogoutUrl());
        }
        String username = this.loadUserName(saml2Profile);
        List<GrantedAuthority> authorities = this.loadGrantedAuthorities(saml2Profile);
        SamlUserDetails userDetails = new SamlUserDetails(username, authorities);
        SamlAuthenticationToken samlAuthToken = new SamlAuthenticationToken(userDetails);
        SecurityContextHolder.getContext().setAuthentication((Authentication)samlAuthToken);
        SecurityListener.fireAuthenticated2((UserDetails)userDetails);
        User user = User.current();
        saveUser |= this.modifyUserFullName(user, saml2Profile);
        List<String> emails = this.getListOfValues(saml2Profile.getAttribute(this.getEmailAttributeName()));
        saveUser |= this.modifyUserEmail(user, emails);
        saveUser |= this.modifyUserSamlCustomAttributes(user, saml2Profile);
        try {
            if (user != null && saveUser) {
                user.save();
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Unable to save updated user data", e);
        }
        SecurityListener.fireLoggedIn((String)userDetails.getUsername());
        return HttpResponses.redirectTo((String)redirectUrl);
    }

    @NonNull
    private List<String> getListOfValues(Object attributeValue) {
        List<String> listOfValues = Collections.emptyList();
        if (attributeValue instanceof List) {
            listOfValues = (List<String>)attributeValue;
        } else if (attributeValue instanceof String) {
            listOfValues = Collections.singletonList((String)attributeValue);
        }
        return listOfValues;
    }

    private String getEffectiveLogoutUrl() {
        return StringUtils.isNotBlank((CharSequence)this.getLogoutUrl()) ? this.getLogoutUrl() : Jenkins.get().getRootUrl() + "samlLogout";
    }

    private void recreateSession(StaplerRequest2 request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            LOG.finest("Invalidate previous session");
            session.invalidate();
        }
        request.getSession(true);
    }

    private boolean modifyUserSamlCustomAttributes(User user, SAML2Profile profile) {
        boolean saveUser = false;
        if (!this.getSamlCustomAttributes().isEmpty() && user != null) {
            SamlCustomProperty userProperty = new SamlCustomProperty(new ArrayList<SamlCustomProperty.Attribute>());
            for (AttributeEntry attributeEntry : this.getSamlCustomAttributes()) {
                Attribute attr;
                Object attrValue;
                if (!(attributeEntry instanceof Attribute) || (attrValue = profile.getAttribute((attr = (Attribute)attributeEntry).getName())) == null) continue;
                SamlCustomProperty.Attribute item = new SamlCustomProperty.Attribute(attr.getName(), attr.getDisplayName());
                item.setValue(attrValue.toString());
                userProperty.getAttributes().add(item);
            }
            try {
                user.addProperty((UserProperty)userProperty);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Could not update user SAML custom attributes", e);
            }
            saveUser = true;
        }
        return saveUser;
    }

    private void logSamlResponse(StaplerRequest2 request) {
        if (LOG.isLoggable(Level.FINEST)) {
            try {
                String samlResponse = request.getParameter("SAMLResponse");
                if (Base64.isBase64((String)samlResponse)) {
                    LOG.finest("SAMLResponse XML:" + new String(Base64.decodeBase64((String)samlResponse), request.getCharacterEncoding()));
                } else {
                    LOG.finest("SAMLResponse XML:" + samlResponse);
                }
            }
            catch (Exception e) {
                LOG.finest("No UTF-8 SAMLResponse XML");
                try (ServletInputStream in = request.getInputStream();){
                    LOG.finest(IOUtils.toString((InputStream)in, (String)request.getCharacterEncoding()));
                }
                catch (IOException e1) {
                    LOG.finest("Was not possible to read the request");
                }
            }
        }
    }

    static String baseUrl() {
        return Jenkins.get().getRootUrl();
    }

    private String loadUserName(SAML2Profile saml2Profile) {
        String username = this.getUsernameFromProfile(saml2Profile);
        if ("lowercase".compareTo(this.getUsernameCaseConversion()) == 0) {
            username = username.toLowerCase();
        } else if ("uppercase".compareTo(this.getUsernameCaseConversion()) == 0) {
            username = username.toUpperCase();
        }
        return username;
    }

    private boolean modifyUserFullName(User user, SAML2Profile saml2Profile) {
        boolean saveUser = false;
        String userFullName = null;
        List<String> names = this.getListOfValues(saml2Profile.getAttribute(this.getDisplayNameAttributeName()));
        if (!names.isEmpty()) {
            userFullName = names.get(0);
        }
        if (user != null && StringUtils.isNotBlank(userFullName) && userFullName.compareTo(user.getFullName()) != 0) {
            user.setFullName(userFullName);
            saveUser = true;
        }
        return saveUser;
    }

    @Restricted(value={NoExternalUse.class})
    List<GrantedAuthority> loadGrantedAuthorities(SAML2Profile saml2Profile) {
        List<String> groups = this.getListOfValues(saml2Profile.getAttribute(this.getGroupsAttributeName()));
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        authorities.add(AUTHENTICATED_AUTHORITY2);
        int countEmptyGroups = 0;
        for (String group : groups) {
            if (StringUtils.isNotBlank((CharSequence)group)) {
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority(group));
                continue;
            }
            ++countEmptyGroups;
        }
        if (countEmptyGroups > 0) {
            LOG.log(Level.WARNING, String.format("Found %d empty groups in the saml profile for %s. Please check the SAML backend configuration.", countEmptyGroups, this.getUsernameFromProfile(saml2Profile)));
        }
        return authorities;
    }

    private boolean modifyUserEmail(User user, @NonNull List<String> emails) {
        String userEmail = null;
        boolean saveUser = false;
        if (emails.isEmpty()) {
            LOG.warning("There is not Email attribute '" + this.getEmailAttributeName() + "' for user : " + user.getId());
            return false;
        }
        for (String item : emails) {
            if (!StringUtils.isNotEmpty((CharSequence)item)) continue;
            userEmail = item;
            break;
        }
        if (StringUtils.isBlank(userEmail)) {
            LOG.warning("The Email is blank for user : " + user.getId());
        }
        try {
            Mailer.UserProperty currentUserEmailProperty;
            if (user != null && StringUtils.isNotBlank(userEmail) && ((currentUserEmailProperty = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)) == null || userEmail.compareTo((String)StringUtils.defaultIfBlank((CharSequence)currentUserEmailProperty.getAddress(), (CharSequence)"")) != 0)) {
                Mailer.UserProperty emailProperty = new Mailer.UserProperty(userEmail);
                user.addProperty((UserProperty)emailProperty);
                saveUser = true;
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not update user email", e);
        }
        return saveUser;
    }

    private String getUsernameFromProfile(SAML2Profile saml2Profile) {
        if (this.getUsernameAttributeName() != null) {
            List<String> attributes = this.getListOfValues(saml2Profile.getAttribute(this.getUsernameAttributeName()));
            if (!attributes.isEmpty()) {
                return attributes.get(0);
            }
            LOG.log(Level.SEVERE, "Unable to get username from attribute {0} value {1}, Saml Profile {2}", new Object[]{this.getUsernameAttributeName(), attributes.toString(), saml2Profile});
            LOG.log(Level.SEVERE, "Falling back to NameId {0}", saml2Profile.getId());
        }
        return saml2Profile.getId();
    }

    static String getIDPMetadataFilePath() {
        return Jenkins.get().getRootDir().getAbsolutePath() + File.separator + IDP_METADATA_FILE_NAME;
    }

    static String getSPMetadataFilePath() {
        return Jenkins.get().getRootDir().getAbsolutePath() + File.separator + SP_METADATA_FILE_NAME;
    }

    public HttpResponse doMetadata(StaplerRequest2 request, StaplerResponse2 response) {
        return (HttpResponse)new SamlSPMetadataWrapper(this.getSamlPluginConfig(), request, response).get();
    }

    protected String getPostLogOutUrl2(StaplerRequest2 req, @NonNull Authentication auth) {
        LOG.log(Level.FINE, "Doing Logout {}", auth.getPrincipal());
        if (Jenkins.get().hasPermission(Jenkins.READ) && StringUtils.isBlank((CharSequence)this.getLogoutUrl())) {
            return super.getPostLogOutUrl2(req, auth);
        }
        return this.getEffectiveLogoutUrl();
    }

    @RequirePOST
    public void doLogout(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.READ);
        super.doLogout(req, rsp);
        LOG.log(Level.FINEST, "Here we could do the SAML Single Logout");
    }

    public GroupDetails loadGroupByGroupname2(String groupname, boolean fetchMembers) throws UsernameNotFoundException {
        SamlGroupDetails dg = new SamlGroupDetails(groupname);
        if (dg.getMembers().isEmpty()) {
            throw new UserMayOrMayNotExistException2(groupname);
        }
        return dg;
    }

    public SamlPluginConfig getSamlPluginConfig() {
        return new SamlPluginConfig(this.displayNameAttributeName, this.groupsAttributeName, this.maximumAuthenticationLifetime, this.emailAttributeName, this.idpMetadataConfiguration, this.usernameCaseConversion, this.usernameAttributeName, this.logoutUrl, this.binding, this.encryptionData, this.advancedConfiguration, (List<SamlProperty>)this.properties);
    }

    public String getUsernameAttributeName() {
        return this.usernameAttributeName;
    }

    public String getDisplayNameAttributeName() {
        return this.displayNameAttributeName;
    }

    public String getGroupsAttributeName() {
        return this.groupsAttributeName;
    }

    public Integer getMaximumAuthenticationLifetime() {
        return this.maximumAuthenticationLifetime;
    }

    public SamlAdvancedConfiguration getAdvancedConfiguration() {
        return this.advancedConfiguration;
    }

    public String getBinding() {
        return this.binding;
    }

    public SamlEncryptionData getEncryptionData() {
        return this.encryptionData;
    }

    public String getUsernameCaseConversion() {
        return this.usernameCaseConversion;
    }

    public String getEmailAttributeName() {
        return this.emailAttributeName;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public IdpMetadataConfiguration getIdpMetadataConfiguration() {
        return this.idpMetadataConfiguration;
    }

    @NonNull
    public List<AttributeEntry> getSamlCustomAttributes() {
        if (this.samlCustomAttributes == null) {
            return Collections.emptyList();
        }
        return this.samlCustomAttributes;
    }

    public void setSamlCustomAttribute(List<AttributeEntry> samlCustomAttributes) {
        this.samlCustomAttributes = samlCustomAttributes;
    }

    public String toString() {
        return "SamlSecurityRealm{" + this.getSamlPluginConfig().toString() + "}";
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public DescriptorImpl() {
        }

        public DescriptorImpl(Class<? extends SecurityRealm> clazz) {
            super(clazz);
        }

        @NonNull
        public String getDisplayName() {
            return "SAML 2.0";
        }

        @RequirePOST
        public FormValidation doCheckLogoutUrl(@QueryParameter String logoutUrl) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return SamlFormValidation.checkUrlFormat(logoutUrl);
        }

        @RequirePOST
        public FormValidation doCheckDisplayNameAttributeName(@QueryParameter String displayNameAttributeName) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return SamlFormValidation.checkStringFormat(displayNameAttributeName);
        }

        @RequirePOST
        public FormValidation doCheckGroupsAttributeName(@QueryParameter String groupsAttributeName) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return SamlFormValidation.checkStringAttributeFormat(groupsAttributeName, SamlSecurityRealm.WARN_RECOMMENDED_TO_SET_THE_GROUPS_ATTRIBUTE, true);
        }

        @RequirePOST
        public FormValidation doCheckUsernameAttributeName(@QueryParameter String usernameAttributeName) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return SamlFormValidation.checkStringAttributeFormat(usernameAttributeName, SamlSecurityRealm.WARN_RECOMMENDED_TO_SET_THE_USERNAME_ATTRIBUTE, true);
        }

        @RequirePOST
        public FormValidation doCheckEmailAttributeName(@QueryParameter String emailAttributeName) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return SamlFormValidation.checkStringAttributeFormat(emailAttributeName, SamlSecurityRealm.WARN_RECOMMENDED_TO_SET_THE_EMAIL_ATTRIBUTE, true);
        }

        @RequirePOST
        public FormValidation doCheckMaximumAuthenticationLifetime(@QueryParameter String maximumAuthenticationLifetime) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return SamlFormValidation.checkIntegerFormat(maximumAuthenticationLifetime);
        }

        public boolean isDisplayProperties() {
            return !SamlPropertyDescriptor.all().isEmpty();
        }
    }
}

