/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.pac4j.core.exception.TechnicalException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;

class SamlFileResourceDisk
implements WritableResource {
    private final String fileName;

    public SamlFileResourceDisk(@NonNull String fileName) {
        this.fileName = fileName;
    }

    public SamlFileResourceDisk(@NonNull String fileName, @NonNull String data) {
        this.fileName = fileName;
        try {
            Files.write(this.getFile().toPath(), data.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (UnsupportedEncodingException e) {
            throw new TechnicalException("Could not get string bytes.", (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Could not save the " + fileName + " file.", (Throwable)e);
        }
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public boolean isReadable() {
        return this.getFile().canRead();
    }

    public boolean isOpen() {
        return false;
    }

    @NonNull
    public URL getURL() throws MalformedURLException {
        return this.getURI().toURL();
    }

    @NonNull
    public URI getURI() {
        return this.getFile().toURI();
    }

    public String getFilename() {
        return this.fileName;
    }

    @NonNull
    public String getDescription() {
        return this.fileName;
    }

    @NonNull
    public InputStream getInputStream() throws IOException {
        return FileUtils.openInputStream((File)this.getFile());
    }

    @NonNull
    public File getFile() {
        return new File(this.fileName);
    }

    public long contentLength() {
        return this.getFile().length();
    }

    public long lastModified() {
        return this.getFile().lastModified();
    }

    @NonNull
    public Resource createRelative(@NonNull String s) {
        throw new NotImplementedException();
    }

    public boolean isWritable() {
        return this.getFile().canWrite();
    }

    @NonNull
    public OutputStream getOutputStream() throws IOException {
        return Files.newOutputStream(this.getFile().toPath(), new OpenOption[0]);
    }
}

