/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.saml.SamlFormValidation;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class SamlEncryptionData
extends AbstractDescribableImpl<SamlEncryptionData> {
    private final String keystorePath;
    private Secret keystorePasswordSecret;
    private Secret privateKeyPasswordSecret;
    private final String privateKeyAlias;
    private final boolean forceSignRedirectBindingAuthnRequest;
    private boolean wantsAssertionsSigned;

    @DataBoundConstructor
    public SamlEncryptionData(String keystorePath, Secret keystorePassword, Secret privateKeyPassword, String privateKeyAlias, boolean forceSignRedirectBindingAuthnRequest, boolean wantsAssertionsSigned) {
        this.keystorePath = Util.fixEmptyAndTrim((String)keystorePath);
        if (keystorePassword != null && StringUtils.isNotEmpty((CharSequence)keystorePassword.getPlainText())) {
            this.keystorePasswordSecret = keystorePassword;
        }
        if (privateKeyPassword != null && StringUtils.isNotEmpty((CharSequence)privateKeyPassword.getPlainText())) {
            this.privateKeyPasswordSecret = privateKeyPassword;
        }
        this.privateKeyAlias = Util.fixEmptyAndTrim((String)privateKeyAlias);
        this.forceSignRedirectBindingAuthnRequest = forceSignRedirectBindingAuthnRequest;
        this.wantsAssertionsSigned = wantsAssertionsSigned;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    @CheckForNull
    public Secret getKeystorePassword() {
        return this.keystorePasswordSecret;
    }

    @CheckForNull
    public String getKeystorePasswordPlainText() {
        return this.keystorePasswordSecret != null ? Util.fixEmptyAndTrim((String)this.keystorePasswordSecret.getPlainText()) : null;
    }

    @CheckForNull
    public Secret getPrivateKeyPassword() {
        return this.privateKeyPasswordSecret;
    }

    @CheckForNull
    public String getPrivateKeyPasswordPlainText() {
        return this.privateKeyPasswordSecret != null ? Util.fixEmptyAndTrim((String)this.privateKeyPasswordSecret.getPlainText()) : null;
    }

    public String getPrivateKeyAlias() {
        return this.privateKeyAlias;
    }

    public boolean isForceSignRedirectBindingAuthnRequest() {
        return this.forceSignRedirectBindingAuthnRequest;
    }

    public boolean isWantsAssertionsSigned() {
        return this.wantsAssertionsSigned;
    }

    public void setWantsAssertionsSigned(boolean wantsAssertionsSigned) {
        this.wantsAssertionsSigned = wantsAssertionsSigned;
    }

    public String toString() {
        return "SamlEncryptionData{keystorePath='" + (String)StringUtils.defaultIfBlank((CharSequence)this.keystorePath, (CharSequence)"none") + "', keystorePassword is NOT empty='" + (this.getKeystorePasswordPlainText() != null) + "', privateKeyPassword is NOT empty='" + (this.getPrivateKeyPasswordPlainText() != null) + "', privateKeyAlias is NOT empty='" + StringUtils.isNotEmpty((CharSequence)this.privateKeyAlias) + "', forceSignRedirectBindingAuthnRequest = " + this.forceSignRedirectBindingAuthnRequest + ", wantsAssertionsSigned = " + this.wantsAssertionsSigned + "}";
    }

    private Object readResolve() {
        return this;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SamlEncryptionData> {
        public DescriptorImpl() {
        }

        public DescriptorImpl(Class<? extends SamlEncryptionData> clazz) {
            super(clazz);
        }

        @NonNull
        public String getDisplayName() {
            return "Encryption Configuration";
        }

        @RequirePOST
        public FormValidation doCheckKeystorePath(@QueryParameter String keystorePath) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return SamlFormValidation.checkStringAttributeFormat(keystorePath, "Keystore is not set", true);
        }

        @RequirePOST
        public FormValidation doCheckPrivateKeyAlias(@QueryParameter String privateKeyAlias) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return SamlFormValidation.checkStringAttributeFormat(privateKeyAlias, "Key alias is not set", true);
        }

        @RequirePOST
        public FormValidation doCheckKeystorePassword(@QueryParameter String keystorePassword) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return SamlFormValidation.checkStringAttributeFormat(keystorePassword, "Keystore password is not set", true);
        }

        @RequirePOST
        public FormValidation doCheckPrivateKeyPassword(@QueryParameter String privateKeyPassword) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return SamlFormValidation.checkStringAttributeFormat(privateKeyPassword, "Key password is not set", true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @RequirePOST
        public FormValidation doTestKeyStore(@QueryParameter(value="keystorePath") String keystorePath, @QueryParameter(value="keystorePassword") Secret keystorePassword, @QueryParameter(value="privateKeyPassword") Secret privateKeyPassword, @QueryParameter(value="privateKeyAlias") String privateKeyAlias) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (StringUtils.isBlank((CharSequence)keystorePath)) {
                return FormValidation.warning((String)"There is not keyStore to validate");
            }
            try (FileInputStream in = new FileInputStream(keystorePath);){
                String currentAlias;
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(in, keystorePassword.getPlainText().toCharArray());
                KeyStore.PasswordProtection keyPassword = new KeyStore.PasswordProtection(null);
                if (StringUtils.isNotBlank((CharSequence)privateKeyPassword.getPlainText())) {
                    keyPassword = new KeyStore.PasswordProtection(privateKeyPassword.getPlainText().toCharArray());
                }
                Enumeration<String> aliases = ks.aliases();
                do {
                    if (!aliases.hasMoreElements()) return FormValidation.error((String)"Not key found");
                    currentAlias = aliases.nextElement();
                } while (!StringUtils.isBlank((CharSequence)privateKeyAlias) && !currentAlias.equalsIgnoreCase(privateKeyAlias));
                ks.getEntry(currentAlias, keyPassword);
                FormValidation formValidation = FormValidation.ok((String)"Success");
                return formValidation;
            }
            catch (IOException e) {
                return FormValidation.error((Throwable)e, (String)"It is not possible to read the keystore file.");
            }
            catch (CertificateException e) {
                return FormValidation.error((Throwable)e, (String)"Any of the certificates in the keystore could not be loaded");
            }
            catch (NoSuchAlgorithmException e) {
                return FormValidation.error((Throwable)e, (String)"the algorithm used to check the integrity of the keystore cannot be found");
            }
            catch (KeyStoreException e) {
                return FormValidation.error((Throwable)e, (String)"No Provider supports a KeyStoreSpi implementation for the specified type.");
            }
            catch (UnrecoverableKeyException e) {
                return FormValidation.error((Throwable)e, (String)"The entry is a PrivateKeyEntry or SecretKeyEntry and the specified protParam does not contain the information needed to recover the key (e.g. wrong password)");
            }
            catch (UnrecoverableEntryException e) {
                return FormValidation.error((Throwable)e, (String)"The specified protParam were insufficient or invalid");
            }
        }
    }
}

