/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.saml.SamlFormValidation;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class SamlAdvancedConfiguration
extends AbstractDescribableImpl<SamlAdvancedConfiguration> {
    private final Boolean forceAuthn;
    private final String authnContextClassRef;
    private final String spEntityId;
    private final String nameIdPolicyFormat;
    private Boolean useDiskCache = false;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    private transient Boolean randomRelayState;

    @DataBoundConstructor
    public SamlAdvancedConfiguration(Boolean forceAuthn, String authnContextClassRef, String spEntityId, String nameIdPolicyFormat) {
        this.forceAuthn = forceAuthn != null ? forceAuthn : false;
        this.authnContextClassRef = Util.fixEmptyAndTrim((String)authnContextClassRef);
        this.spEntityId = Util.fixEmptyAndTrim((String)spEntityId);
        this.nameIdPolicyFormat = Util.fixEmptyAndTrim((String)nameIdPolicyFormat);
    }

    public Boolean getForceAuthn() {
        return this.forceAuthn;
    }

    public String getAuthnContextClassRef() {
        return this.authnContextClassRef;
    }

    public String getSpEntityId() {
        return this.spEntityId;
    }

    public String getNameIdPolicyFormat() {
        return this.nameIdPolicyFormat;
    }

    public Boolean getUseDiskCache() {
        return this.useDiskCache != null ? this.useDiskCache : false;
    }

    @DataBoundSetter
    public void setUseDiskCache(Boolean useDiskCache) {
        this.useDiskCache = useDiskCache;
    }

    public String toString() {
        return "SamlAdvancedConfiguration{forceAuthn=" + this.getForceAuthn() + ", authnContextClassRef='" + (String)StringUtils.defaultIfBlank((CharSequence)this.getAuthnContextClassRef(), (CharSequence)"none") + "', spEntityId='" + (String)StringUtils.defaultIfBlank((CharSequence)this.getSpEntityId(), (CharSequence)"none") + "', nameIdPolicyFormat='" + (String)StringUtils.defaultIfBlank((CharSequence)this.getNameIdPolicyFormat(), (CharSequence)"none") + "', useDiskCache=" + this.getUseDiskCache() + "}";
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SamlAdvancedConfiguration> {
        public DescriptorImpl() {
        }

        public DescriptorImpl(Class<? extends SamlAdvancedConfiguration> clazz) {
            super(clazz);
        }

        @NonNull
        public String getDisplayName() {
            return "Advanced Configuration";
        }

        @RequirePOST
        public FormValidation doCheckAuthnContextClassRef(@QueryParameter String authnContextClassRef) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return SamlFormValidation.checkStringFormat(authnContextClassRef);
        }

        @RequirePOST
        public FormValidation doCheckSpEntityId(@QueryParameter String spEntityId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return SamlFormValidation.checkStringFormat(spEntityId);
        }

        @RequirePOST
        public FormValidation doCheckNameIdPolicyFormat(@QueryParameter String nameIdPolicyFormat) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return SamlFormValidation.checkStringFormat(nameIdPolicyFormat);
        }

        @RequirePOST
        public FormValidation doCheckMaximumSessionLifetime(@QueryParameter String maximumSessionLifetime) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (StringUtils.isEmpty((CharSequence)maximumSessionLifetime)) {
                return FormValidation.ok();
            }
            long i = 0L;
            try {
                i = Long.parseLong(maximumSessionLifetime);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"The field should be a number greater than 0 and lower than 2147483647.", (Object[])new Object[]{e});
            }
            if (i < 0L) {
                return FormValidation.error((String)"The field should be a number greater than 0 and lower than 2147483647.");
            }
            if (i > Integer.MAX_VALUE) {
                return FormValidation.error((String)"The field should be a number greater than 0 and lower than 2147483647.");
            }
            return FormValidation.ok();
        }
    }
}

