/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import hudson.ExtensionList;
import java.util.logging.Logger;
import org.jenkinsci.plugins.saml.JenkinsReplayCacheProvider;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.replay.InMemoryReplayCacheProvider;
import org.pac4j.saml.replay.ReplayCacheProvider;

public class JenkinsSAML2Client
extends SAML2Client {
    private static final Logger LOGGER = Logger.getLogger(JenkinsSAML2Client.class.getName());
    static final ReplayCacheProvider REPLAY_CACHE = JenkinsSAML2Client.getProvider();

    public JenkinsSAML2Client(SAML2Configuration config) {
        super(config);
    }

    protected void initSAMLReplayCache(boolean forceReinit) {
        this.replayCache = REPLAY_CACHE;
    }

    private static ReplayCacheProvider getProvider() {
        ExtensionList providers = ExtensionList.lookup(JenkinsReplayCacheProvider.class);
        if (providers.isEmpty()) {
            return new InMemoryReplayCacheProvider();
        }
        if (providers.size() > 1) {
            LOGGER.fine(() -> String.format("There is more than one JenkinsReplayCacheProvider extension registered. Picking [%s] as it's first one in the extensions list.", ((JenkinsReplayCacheProvider)providers.get(0)).getClass().getName()));
        }
        return ((JenkinsReplayCacheProvider)providers.get(0)).getProvider();
    }
}

