/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.saml.IdpMetadataConfiguration;
import org.jenkinsci.plugins.saml.SamlAdvancedConfiguration;
import org.jenkinsci.plugins.saml.SamlEncryptionData;
import org.jenkinsci.plugins.saml.SamlProperty;

public class SamlPluginConfig {
    private final String displayNameAttributeName;
    private final String groupsAttributeName;
    private final int maximumAuthenticationLifetime;
    private final String emailAttributeName;
    private final IdpMetadataConfiguration idpMetadataConfiguration;
    private final String usernameCaseConversion;
    private final String usernameAttributeName;
    private final String logoutUrl;
    private final String binding;
    private final SamlEncryptionData encryptionData;
    private final SamlAdvancedConfiguration advancedConfiguration;
    private final List<SamlProperty> properties;

    public SamlPluginConfig(String displayNameAttributeName, String groupsAttributeName, int maximumAuthenticationLifetime, String emailAttributeName, IdpMetadataConfiguration idpMetadataConfiguration, String usernameCaseConversion, String usernameAttributeName, String logoutUrl, String binding, SamlEncryptionData encryptionData, SamlAdvancedConfiguration advancedConfiguration, @NonNull List<SamlProperty> properties) {
        this.displayNameAttributeName = displayNameAttributeName;
        this.groupsAttributeName = groupsAttributeName;
        this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
        this.emailAttributeName = emailAttributeName;
        this.idpMetadataConfiguration = idpMetadataConfiguration;
        this.usernameCaseConversion = StringUtils.defaultIfBlank((String)usernameCaseConversion, (String)"none");
        this.usernameAttributeName = Util.fixEmptyAndTrim((String)usernameAttributeName);
        this.logoutUrl = logoutUrl;
        this.binding = binding;
        this.encryptionData = encryptionData;
        this.advancedConfiguration = advancedConfiguration;
        this.properties = List.copyOf(properties);
    }

    public String getUsernameAttributeName() {
        return this.usernameAttributeName;
    }

    public String getDisplayNameAttributeName() {
        return this.displayNameAttributeName;
    }

    public String getGroupsAttributeName() {
        return this.groupsAttributeName;
    }

    public Integer getMaximumAuthenticationLifetime() {
        return this.maximumAuthenticationLifetime;
    }

    public SamlAdvancedConfiguration getAdvancedConfiguration() {
        return this.advancedConfiguration;
    }

    public Boolean getForceAuthn() {
        return this.getAdvancedConfiguration() != null ? this.getAdvancedConfiguration().getForceAuthn() : Boolean.FALSE;
    }

    public String getAuthnContextClassRef() {
        return this.getAdvancedConfiguration() != null ? this.getAdvancedConfiguration().getAuthnContextClassRef() : null;
    }

    public String getSpEntityId() {
        return this.getAdvancedConfiguration() != null ? this.getAdvancedConfiguration().getSpEntityId() : null;
    }

    public String getNameIdPolicyFormat() {
        return this.getAdvancedConfiguration() != null ? this.getAdvancedConfiguration().getNameIdPolicyFormat() : null;
    }

    public SamlEncryptionData getEncryptionData() {
        return this.encryptionData;
    }

    public String getUsernameCaseConversion() {
        return this.usernameCaseConversion;
    }

    public String getEmailAttributeName() {
        return this.emailAttributeName;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public String getConsumerServiceUrl() {
        return this.baseUrl() + "securityRealm/finishLogin";
    }

    public String baseUrl() {
        return Jenkins.get().getRootUrl();
    }

    public IdpMetadataConfiguration getIdpMetadataConfiguration() {
        return this.idpMetadataConfiguration;
    }

    public String getBinding() {
        return this.binding;
    }

    @NonNull
    public List<SamlProperty> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "SamlPluginConfig{idpMetadataConfiguration='" + String.valueOf((Object)this.getIdpMetadataConfiguration()) + "', displayNameAttributeName='" + this.getDisplayNameAttributeName() + "', groupsAttributeName='" + this.getGroupsAttributeName() + "', emailAttributeName='" + this.getEmailAttributeName() + "', usernameAttributeName='" + this.getUsernameAttributeName() + "', maximumAuthenticationLifetime=" + this.getMaximumAuthenticationLifetime() + ", usernameCaseConversion='" + this.getUsernameCaseConversion() + "', logoutUrl='" + this.getLogoutUrl() + "', binding='" + this.getBinding() + "', encryptionData=" + String.valueOf((Object)this.getEncryptionData()) + ", advancedConfiguration=" + String.valueOf((Object)this.getAdvancedConfiguration()) + ",properties=" + String.valueOf(this.getProperties()) + "}";
    }
}

