/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import hudson.Util;
import java.time.Duration;
import java.util.UUID;
import java.util.logging.Logger;
import org.jenkinsci.plugins.saml.SamlSecurityRealm;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.generator.ValueGenerator;

@Restricted(value={NoExternalUse.class})
class RefererStateGenerator
implements ValueGenerator {
    private static final Logger LOGGER = Logger.getLogger(RefererStateGenerator.class.getName());
    public static final Cache<String, String> CACHE = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(Duration.ofMinutes(30L)).build();

    RefererStateGenerator() {
    }

    public String generateValue(CallContext ctx) {
        WebContext webContext = ctx.webContext();
        String referer = webContext.getRequestHeader("Referer").orElse(null);
        String from = webContext.getRequestParameter("from").orElse(null);
        String id = UUID.randomUUID().toString();
        CACHE.put((Object)id, (Object)RefererStateGenerator.calculateSafeRedirect(from, referer));
        return id;
    }

    private static String calculateSafeRedirect(String from, String referer) {
        String rootUrl = SamlSecurityRealm.baseUrl();
        String redirectURL = from != null && Util.isSafeToRedirectTo((String)from) ? from : (referer != null && (referer.startsWith(rootUrl) || Util.isSafeToRedirectTo((String)referer)) ? referer : rootUrl);
        LOGGER.fine("Safe URL redirection: " + redirectURL);
        return redirectURL;
    }
}

