/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.User;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException2;
import java.util.ArrayList;
import java.util.Collections;
import jenkins.model.Jenkins;
import jenkins.security.LastGrantedAuthoritiesProperty;
import org.jenkinsci.plugins.saml.SamlAuthenticationToken;
import org.jenkinsci.plugins.saml.SamlUserDetails;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetailsService;

public class SamlUserDetailsService
implements UserDetailsService {
    public SamlUserDetails loadUserByUsername(@NonNull String username) {
        LastGrantedAuthoritiesProperty lastGranted;
        Authentication auth = Jenkins.getAuthentication2();
        if (username.compareTo(auth.getName()) == 0 && auth instanceof SamlAuthenticationToken) {
            return (SamlUserDetails)auth.getDetails();
        }
        User user = User.get((String)username, (boolean)false, Collections.emptyMap());
        if (user == null) {
            throw new UserMayOrMayNotExistException2(username);
        }
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        authorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY2);
        if (username.compareTo(user.getId()) == 0 && (lastGranted = (LastGrantedAuthoritiesProperty)user.getProperty(LastGrantedAuthoritiesProperty.class)) != null) {
            for (GrantedAuthority a : lastGranted.getAuthorities2()) {
                if (a == SecurityRealm.AUTHENTICATED_AUTHORITY2) continue;
                SimpleGrantedAuthority ga = new SimpleGrantedAuthority(a.getAuthority());
                authorities.add((GrantedAuthority)ga);
            }
        }
        return new SamlUserDetails(user.getId(), authorities);
    }
}

