/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public final class S3Artifact
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final String name;
    private final String region;
    private Boolean useFullProjectName;

    public S3Artifact(String region, String bucket, String name) {
        this.bucket = bucket.intern();
        this.name = name.intern();
        this.region = region.intern();
        this.useFullProjectName = true;
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.useFullProjectName = false;
    }

    @Exported
    public String getBucket() {
        return this.bucket;
    }

    @Exported
    public String getName() {
        return this.name;
    }

    @Exported
    public String getRegion() {
        return this.region;
    }

    public Boolean useFullProjectName() {
        if (this.useFullProjectName == null) {
            return false;
        }
        return this.useFullProjectName;
    }
}

