// CHECKSTYLE:OFF

package hudson.plugins.s3;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code CopyArtifact.MissingBuild}: {@code Unable to find a build

     * for artifact copy from: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to find a build for artifact copy from: {0}}
     */
    public static String CopyArtifact_MissingBuild(Object arg0) {
        return holder.format("CopyArtifact.MissingBuild", arg0);
    }

    /**
     * Key {@code CopyArtifact.MissingBuild}: {@code Unable to find a build

     * for artifact copy from: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to find a build for artifact copy from: {0}}
     */
    public static Localizable _CopyArtifact_MissingBuild(Object arg0) {
        return new Localizable(holder, "CopyArtifact.MissingBuild", arg0);
    }

    /**
     * Key {@code CopyArtifact.MissingProject}: {@code Unable to find project

     * for artifact copy: {0}
     * This may be due to incorrect project name or

     * permission settings; see help for project name in job configuration.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to find project for artifact copy: {0}
     *     This may be due

     *     to incorrect project name or permission settings; see help for project

     *     name in job configuration.}
     */
    public static String CopyArtifact_MissingProject(Object arg0) {
        return holder.format("CopyArtifact.MissingProject", arg0);
    }

    /**
     * Key {@code CopyArtifact.MissingProject}: {@code Unable to find project

     * for artifact copy: {0}
     * This may be due to incorrect project name or

     * permission settings; see help for project name in job configuration.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to find project for artifact copy: {0}
     *     This may be due

     *     to incorrect project name or permission settings; see help for project

     *     name in job configuration.}
     */
    public static Localizable _CopyArtifact_MissingProject(Object arg0) {
        return new Localizable(holder, "CopyArtifact.MissingProject", arg0);
    }

    /**
     * Key {@code CopyArtifact.FailedToCopy}: {@code Failed to copy artifacts

     * from {0} with filter: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to copy artifacts from {0} with filter: {1}}
     */
    public static String CopyArtifact_FailedToCopy(Object arg0, Object arg1) {
        return holder.format("CopyArtifact.FailedToCopy", arg0, arg1);
    }

    /**
     * Key {@code CopyArtifact.FailedToCopy}: {@code Failed to copy artifacts

     * from {0} with filter: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to copy artifacts from {0} with filter: {1}}
     */
    public static Localizable _CopyArtifact_FailedToCopy(Object arg0, Object arg1) {
        return new Localizable(holder, "CopyArtifact.FailedToCopy", arg0, arg1);
    }

    /**
     * Key {@code CopyArtifact.MissingSrcWorkspace}: {@code Unable to access

     * upstream workspace for artifact copy. Slave node offline?}.
     * 
     * @return
     *     {@code Unable to access upstream workspace for artifact copy. Slave

     *     node offline?}
     */
    public static String CopyArtifact_MissingSrcWorkspace() {
        return holder.format("CopyArtifact.MissingSrcWorkspace");
    }

    /**
     * Key {@code CopyArtifact.MissingSrcWorkspace}: {@code Unable to access

     * upstream workspace for artifact copy. Slave node offline?}.
     * 
     * @return
     *     {@code Unable to access upstream workspace for artifact copy. Slave

     *     node offline?}
     */
    public static Localizable _CopyArtifact_MissingSrcWorkspace() {
        return new Localizable(holder, "CopyArtifact.MissingSrcWorkspace");
    }

    /**
     * Key {@code CopyArtifact.MavenProject}: {@code Artifacts will be copied

     * from all modules of this Maven project; click the help icon to learn

     * about selecting a particular module.}.
     * 
     * @return
     *     {@code Artifacts will be copied from all modules of this Maven

     *     project; click the help icon to learn about selecting a particular

     *     module.}
     */
    public static String CopyArtifact_MavenProject() {
        return holder.format("CopyArtifact.MavenProject");
    }

    /**
     * Key {@code CopyArtifact.MavenProject}: {@code Artifacts will be copied

     * from all modules of this Maven project; click the help icon to learn

     * about selecting a particular module.}.
     * 
     * @return
     *     {@code Artifacts will be copied from all modules of this Maven

     *     project; click the help icon to learn about selecting a particular

     *     module.}
     */
    public static Localizable _CopyArtifact_MavenProject() {
        return new Localizable(holder, "CopyArtifact.MavenProject");
    }

    /**
     * Key {@code BuildTrigger.NoSuchProject}: {@code No such project

     * ‘{0}’.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such project ‘{0}’.}
     */
    public static String BuildTrigger_NoSuchProject(Object arg0) {
        return holder.format("BuildTrigger.NoSuchProject", arg0);
    }

    /**
     * Key {@code BuildTrigger.NoSuchProject}: {@code No such project

     * ‘{0}’.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such project ‘{0}’.}
     */
    public static Localizable _BuildTrigger_NoSuchProject(Object arg0) {
        return new Localizable(holder, "BuildTrigger.NoSuchProject", arg0);
    }

    /**
     * Key {@code CopyArtifact.ParameterizedName}: {@code Value references a

     * build parameter, so it cannot be validated.}.
     * 
     * @return
     *     {@code Value references a build parameter, so it cannot be validated.}
     */
    public static String CopyArtifact_ParameterizedName() {
        return holder.format("CopyArtifact.ParameterizedName");
    }

    /**
     * Key {@code CopyArtifact.ParameterizedName}: {@code Value references a

     * build parameter, so it cannot be validated.}.
     * 
     * @return
     *     {@code Value references a build parameter, so it cannot be validated.}
     */
    public static Localizable _CopyArtifact_ParameterizedName() {
        return new Localizable(holder, "CopyArtifact.ParameterizedName");
    }

    /**
     * Key {@code CopyArtifact.MatrixProject}: {@code Artifacts will be

     * copied from all configurations of this multiconfiguration project;

     * click the help icon to learn about selecting a particular

     * configuration.}.
     * 
     * @return
     *     {@code Artifacts will be copied from all configurations of this

     *     multiconfiguration project; click the help icon to learn about

     *     selecting a particular configuration.}
     */
    public static String CopyArtifact_MatrixProject() {
        return holder.format("CopyArtifact.MatrixProject");
    }

    /**
     * Key {@code CopyArtifact.MatrixProject}: {@code Artifacts will be

     * copied from all configurations of this multiconfiguration project;

     * click the help icon to learn about selecting a particular

     * configuration.}.
     * 
     * @return
     *     {@code Artifacts will be copied from all configurations of this

     *     multiconfiguration project; click the help icon to learn about

     *     selecting a particular configuration.}
     */
    public static Localizable _CopyArtifact_MatrixProject() {
        return new Localizable(holder, "CopyArtifact.MatrixProject");
    }

    /**
     * Key {@code BuildTrigger.NoSuchProjectWithSuggestion}: {@code No such

     * project ‘{0}’. Did you mean ‘{1}’?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such project ‘{0}’. Did you mean ‘{1}’?}
     */
    public static String BuildTrigger_NoSuchProjectWithSuggestion(Object arg0, Object arg1) {
        return holder.format("BuildTrigger.NoSuchProjectWithSuggestion", arg0, arg1);
    }

    /**
     * Key {@code BuildTrigger.NoSuchProjectWithSuggestion}: {@code No such

     * project ‘{0}’. Did you mean ‘{1}’?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such project ‘{0}’. Did you mean ‘{1}’?}
     */
    public static Localizable _BuildTrigger_NoSuchProjectWithSuggestion(Object arg0, Object arg1) {
        return new Localizable(holder, "BuildTrigger.NoSuchProjectWithSuggestion", arg0, arg1);
    }

}
