// CHECKSTYLE:OFF

package org.jenkins_ci.plugins.run_condition.common;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code baseDirectory.artifacts.displayName}: {@code Artifacts
     * directory}.
     * 
     * @return
     *     {@code Artifacts directory}
     */
    public static String baseDirectory_artifacts_displayName() {
        return holder.format("baseDirectory.artifacts.displayName");
    }

    /**
     * Key {@code baseDirectory.artifacts.displayName}: {@code Artifacts
     * directory}.
     * 
     * @return
     *     {@code Artifacts directory}
     */
    public static Localizable _baseDirectory_artifacts_displayName() {
        return new Localizable(holder, "baseDirectory.artifacts.displayName");
    }

    /**
     * Key {@code baseDirectory.workspace.displayName}: {@code Workspace}.
     * 
     * @return
     *     {@code Workspace}
     */
    public static String baseDirectory_workspace_displayName() {
        return holder.format("baseDirectory.workspace.displayName");
    }

    /**
     * Key {@code baseDirectory.workspace.displayName}: {@code Workspace}.
     * 
     * @return
     *     {@code Workspace}
     */
    public static Localizable _baseDirectory_workspace_displayName() {
        return new Localizable(holder, "baseDirectory.workspace.displayName");
    }

    /**
     * Key {@code baseDirectory.jenkinsHome.displayName}: {@code
     * $JENKINS_HOME (on master)}.
     * 
     * @return
     *     {@code $JENKINS_HOME (on master)}
     */
    public static String baseDirectory_jenkinsHome_displayName() {
        return holder.format("baseDirectory.jenkinsHome.displayName");
    }

    /**
     * Key {@code baseDirectory.jenkinsHome.displayName}: {@code
     * $JENKINS_HOME (on master)}.
     * 
     * @return
     *     {@code $JENKINS_HOME (on master)}
     */
    public static Localizable _baseDirectory_jenkinsHome_displayName() {
        return new Localizable(holder, "baseDirectory.jenkinsHome.displayName");
    }

}
