// CHECKSTYLE:OFF

package org.jenkins_ci.plugins.run_condition;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code causeCondition.check}: {@code [Build Cause] check if build
     * was triggered by [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Build Cause] check if build was triggered by [{0}]}
     */
    public static String causeCondition_check(Object arg0) {
        return holder.format("causeCondition.check", arg0);
    }

    /**
     * Key {@code causeCondition.check}: {@code [Build Cause] check if build
     * was triggered by [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Build Cause] check if build was triggered by [{0}]}
     */
    public static Localizable _causeCondition_check(Object arg0) {
        return new Localizable(holder, "causeCondition.check", arg0);
    }

    /**
     * Key {@code runner.condition.false}: {@code Run condition [{0}]
     * preventing {1} for step [{2}]}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Run condition [{0}] preventing {1} for step [{2}]}
     */
    public static String runner_condition_false(Object arg0, Object arg1, Object arg2) {
        return holder.format("runner.condition.false", arg0, arg1, arg2);
    }

    /**
     * Key {@code runner.condition.false}: {@code Run condition [{0}]
     * preventing {1} for step [{2}]}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Run condition [{0}] preventing {1} for step [{2}]}
     */
    public static Localizable _runner_condition_false(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "runner.condition.false", arg0, arg1, arg2);
    }

    /**
     * Key {@code logic.or.displayName}: {@code Or}.
     * 
     * @return
     *     {@code Or}
     */
    public static String logic_or_displayName() {
        return holder.format("logic.or.displayName");
    }

    /**
     * Key {@code logic.or.displayName}: {@code Or}.
     * 
     * @return
     *     {@code Or}
     */
    public static Localizable _logic_or_displayName() {
        return new Localizable(holder, "logic.or.displayName");
    }

    /**
     * Key {@code timeCondition.validation.invalid}: {@code The time [{0}] is
     * not valid. Valid times are 00:00 to 23:59 e.g. 8:07 or 09:05}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The time [{0}] is not valid. Valid times are 00:00 to 23:59
     *     e.g. 8:07 or 09:05}
     */
    public static String timeCondition_validation_invalid(Object arg0) {
        return holder.format("timeCondition.validation.invalid", arg0);
    }

    /**
     * Key {@code timeCondition.validation.invalid}: {@code The time [{0}] is
     * not valid. Valid times are 00:00 to 23:59 e.g. 8:07 or 09:05}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The time [{0}] is not valid. Valid times are 00:00 to 23:59
     *     e.g. 8:07 or 09:05}
     */
    public static Localizable _timeCondition_validation_invalid(Object arg0) {
        return new Localizable(holder, "timeCondition.validation.invalid", arg0);
    }

    /**
     * Key {@code dayCondition.displayName}: {@code Day of week}.
     * 
     * @return
     *     {@code Day of week}
     */
    public static String dayCondition_displayName() {
        return holder.format("dayCondition.displayName");
    }

    /**
     * Key {@code dayCondition.displayName}: {@code Day of week}.
     * 
     * @return
     *     {@code Day of week}
     */
    public static Localizable _dayCondition_displayName() {
        return new Localizable(holder, "dayCondition.displayName");
    }

    /**
     * Key {@code numericalComparison.equalTo}: {@code == Equal to}.
     * 
     * @return
     *     {@code == Equal to}
     */
    public static String numericalComparison_equalTo() {
        return holder.format("numericalComparison.equalTo");
    }

    /**
     * Key {@code numericalComparison.equalTo}: {@code == Equal to}.
     * 
     * @return
     *     {@code == Equal to}
     */
    public static Localizable _numericalComparison_equalTo() {
        return new Localizable(holder, "numericalComparison.equalTo");
    }

    /**
     * Key {@code booleanCondition.displayName}: {@code Boolean condition}.
     * 
     * @return
     *     {@code Boolean condition}
     */
    public static String booleanCondition_displayName() {
        return holder.format("booleanCondition.displayName");
    }

    /**
     * Key {@code booleanCondition.displayName}: {@code Boolean condition}.
     * 
     * @return
     *     {@code Boolean condition}
     */
    public static Localizable _booleanCondition_displayName() {
        return new Localizable(holder, "booleanCondition.displayName");
    }

    /**
     * Key {@code dayCondition.weekday.displayName}: {@code Weekdays}.
     * 
     * @return
     *     {@code Weekdays}
     */
    public static String dayCondition_weekday_displayName() {
        return holder.format("dayCondition.weekday.displayName");
    }

    /**
     * Key {@code dayCondition.weekday.displayName}: {@code Weekdays}.
     * 
     * @return
     *     {@code Weekdays}
     */
    public static Localizable _dayCondition_weekday_displayName() {
        return new Localizable(holder, "dayCondition.weekday.displayName");
    }

    /**
     * Key {@code expressionCondition.displayName}: {@code Regular expression
     * match}.
     * 
     * @return
     *     {@code Regular expression match}
     */
    public static String expressionCondition_displayName() {
        return holder.format("expressionCondition.displayName");
    }

    /**
     * Key {@code expressionCondition.displayName}: {@code Regular expression
     * match}.
     * 
     * @return
     *     {@code Regular expression match}
     */
    public static Localizable _expressionCondition_displayName() {
        return new Localizable(holder, "expressionCondition.displayName");
    }

    /**
     * Key {@code statusCondition.exception.unknownResult}: {@code Unknown
     * result name [{0}]. Valid names are SUCCESS, UNSTABLE, FAILURE,
     * NOT_BUILT and ABORTED.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown result name [{0}]. Valid names are SUCCESS, UNSTABLE,
     *     FAILURE, NOT_BUILT and ABORTED.}
     */
    public static String statusCondition_exception_unknownResult(Object arg0) {
        return holder.format("statusCondition.exception.unknownResult", arg0);
    }

    /**
     * Key {@code statusCondition.exception.unknownResult}: {@code Unknown
     * result name [{0}]. Valid names are SUCCESS, UNSTABLE, FAILURE,
     * NOT_BUILT and ABORTED.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown result name [{0}]. Valid names are SUCCESS, UNSTABLE,
     *     FAILURE, NOT_BUILT and ABORTED.}
     */
    public static Localizable _statusCondition_exception_unknownResult(Object arg0) {
        return new Localizable(holder, "statusCondition.exception.unknownResult", arg0);
    }

    /**
     * Key {@code statusCondition.displayName}: {@code Current build status}.
     * 
     * @return
     *     {@code Current build status}
     */
    public static String statusCondition_displayName() {
        return holder.format("statusCondition.displayName");
    }

    /**
     * Key {@code statusCondition.displayName}: {@code Current build status}.
     * 
     * @return
     *     {@code Current build status}
     */
    public static Localizable _statusCondition_displayName() {
        return new Localizable(holder, "statusCondition.displayName");
    }

    /**
     * Key {@code runner.runUnstable.displayName}: {@code Run and mark the
     * build unstable}.
     * 
     * @return
     *     {@code Run and mark the build unstable}
     */
    public static String runner_runUnstable_displayName() {
        return holder.format("runner.runUnstable.displayName");
    }

    /**
     * Key {@code runner.runUnstable.displayName}: {@code Run and mark the
     * build unstable}.
     * 
     * @return
     *     {@code Run and mark the build unstable}
     */
    public static Localizable _runner_runUnstable_displayName() {
        return new Localizable(holder, "runner.runUnstable.displayName");
    }

    /**
     * Key {@code statusCondition.validation.bestWorseThanWorst}: {@code The
     * Best status must be better than or equal to the Worst status}.
     * 
     * @return
     *     {@code The Best status must be better than or equal to the Worst
     *     status}
     */
    public static String statusCondition_validation_bestWorseThanWorst() {
        return holder.format("statusCondition.validation.bestWorseThanWorst");
    }

    /**
     * Key {@code statusCondition.validation.bestWorseThanWorst}: {@code The
     * Best status must be better than or equal to the Worst status}.
     * 
     * @return
     *     {@code The Best status must be better than or equal to the Worst
     *     status}
     */
    public static Localizable _statusCondition_validation_bestWorseThanWorst() {
        return new Localizable(holder, "statusCondition.validation.bestWorseThanWorst");
    }

    /**
     * Key {@code numericalComparison.greaterThan}: {@code > Greater than}.
     * 
     * @return
     *     {@code > Greater than}
     */
    public static String numericalComparison_greaterThan() {
        return holder.format("numericalComparison.greaterThan");
    }

    /**
     * Key {@code numericalComparison.greaterThan}: {@code > Greater than}.
     * 
     * @return
     *     {@code > Greater than}
     */
    public static Localizable _numericalComparison_greaterThan() {
        return new Localizable(holder, "numericalComparison.greaterThan");
    }

    /**
     * Key {@code runner.condition.true}: {@code Run condition [{0}] enabling
     * {1} for step [{2}]}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Run condition [{0}] enabling {1} for step [{2}]}
     */
    public static String runner_condition_true(Object arg0, Object arg1, Object arg2) {
        return holder.format("runner.condition.true", arg0, arg1, arg2);
    }

    /**
     * Key {@code runner.condition.true}: {@code Run condition [{0}] enabling
     * {1} for step [{2}]}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Run condition [{0}] enabling {1} for step [{2}]}
     */
    public static Localizable _runner_condition_true(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "runner.condition.true", arg0, arg1, arg2);
    }

    /**
     * Key {@code dayCondition.weekend.displayName}: {@code Weekends}.
     * 
     * @return
     *     {@code Weekends}
     */
    public static String dayCondition_weekend_displayName() {
        return holder.format("dayCondition.weekend.displayName");
    }

    /**
     * Key {@code dayCondition.weekend.displayName}: {@code Weekends}.
     * 
     * @return
     *     {@code Weekends}
     */
    public static Localizable _dayCondition_weekend_displayName() {
        return new Localizable(holder, "dayCondition.weekend.displayName");
    }

    /**
     * Key {@code variableExistsCondition.check}: {@code Variable Existence
     * Condition: checking "{0}" variable }.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Variable Existence Condition: checking "{0}" variable }
     */
    public static String variableExistsCondition_check(Object arg0) {
        return holder.format("variableExistsCondition.check", arg0);
    }

    /**
     * Key {@code variableExistsCondition.check}: {@code Variable Existence
     * Condition: checking "{0}" variable }.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Variable Existence Condition: checking "{0}" variable }
     */
    public static Localizable _variableExistsCondition_check(Object arg0) {
        return new Localizable(holder, "variableExistsCondition.check", arg0);
    }

    /**
     * Key {@code logic.not.displayName}: {@code Not}.
     * 
     * @return
     *     {@code Not}
     */
    public static String logic_not_displayName() {
        return holder.format("logic.not.displayName");
    }

    /**
     * Key {@code logic.not.displayName}: {@code Not}.
     * 
     * @return
     *     {@code Not}
     */
    public static Localizable _logic_not_displayName() {
        return new Localizable(holder, "logic.not.displayName");
    }

    /**
     * Key {@code expressionCondition.console.args}: {@code Regular
     * expression run condition: Expression=[{0}], Label=[{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Regular expression run condition: Expression=[{0}],
     *     Label=[{1}]}
     */
    public static String expressionCondition_console_args(Object arg0, Object arg1) {
        return holder.format("expressionCondition.console.args", arg0, arg1);
    }

    /**
     * Key {@code expressionCondition.console.args}: {@code Regular
     * expression run condition: Expression=[{0}], Label=[{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Regular expression run condition: Expression=[{0}],
     *     Label=[{1}]}
     */
    public static Localizable _expressionCondition_console_args(Object arg0, Object arg1) {
        return new Localizable(holder, "expressionCondition.console.args", arg0, arg1);
    }

    /**
     * Key {@code runner.unstable.displayName}: {@code Mark the build
     * unstable}.
     * 
     * @return
     *     {@code Mark the build unstable}
     */
    public static String runner_unstable_displayName() {
        return holder.format("runner.unstable.displayName");
    }

    /**
     * Key {@code runner.unstable.displayName}: {@code Mark the build
     * unstable}.
     * 
     * @return
     *     {@code Mark the build unstable}
     */
    public static Localizable _runner_unstable_displayName() {
        return new Localizable(holder, "runner.unstable.displayName");
    }

    /**
     * Key {@code timeCondition.console.testing}: {@code Time condition:
     * evaluating [{0}] <= {1} <= [{2}]}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Time condition: evaluating [{0}] <= {1} <= [{2}]}
     */
    public static String timeCondition_console_testing(Object arg0, Object arg1, Object arg2) {
        return holder.format("timeCondition.console.testing", arg0, arg1, arg2);
    }

    /**
     * Key {@code timeCondition.console.testing}: {@code Time condition:
     * evaluating [{0}] <= {1} <= [{2}]}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Time condition: evaluating [{0}] <= {1} <= [{2}]}
     */
    public static Localizable _timeCondition_console_testing(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "timeCondition.console.testing", arg0, arg1, arg2);
    }

    /**
     * Key {@code statusCondition.validation.worseBetterThanBest}: {@code The
     * Worst status must be worse than or equal to the Best status}.
     * 
     * @return
     *     {@code The Worst status must be worse than or equal to the Best
     *     status}
     */
    public static String statusCondition_validation_worseBetterThanBest() {
        return holder.format("statusCondition.validation.worseBetterThanBest");
    }

    /**
     * Key {@code statusCondition.validation.worseBetterThanBest}: {@code The
     * Worst status must be worse than or equal to the Best status}.
     * 
     * @return
     *     {@code The Worst status must be worse than or equal to the Best
     *     status}
     */
    public static Localizable _statusCondition_validation_worseBetterThanBest() {
        return new Localizable(holder, "statusCondition.validation.worseBetterThanBest");
    }

    /**
     * Key {@code fileExistsCondition.displayName}: {@code File exists}.
     * 
     * @return
     *     {@code File exists}
     */
    public static String fileExistsCondition_displayName() {
        return holder.format("fileExistsCondition.displayName");
    }

    /**
     * Key {@code fileExistsCondition.displayName}: {@code File exists}.
     * 
     * @return
     *     {@code File exists}
     */
    public static Localizable _fileExistsCondition_displayName() {
        return new Localizable(holder, "fileExistsCondition.displayName");
    }

    /**
     * Key {@code stringsMatchCondition.displayName}: {@code Strings match}.
     * 
     * @return
     *     {@code Strings match}
     */
    public static String stringsMatchCondition_displayName() {
        return holder.format("stringsMatchCondition.displayName");
    }

    /**
     * Key {@code stringsMatchCondition.displayName}: {@code Strings match}.
     * 
     * @return
     *     {@code Strings match}
     */
    public static Localizable _stringsMatchCondition_displayName() {
        return new Localizable(holder, "stringsMatchCondition.displayName");
    }

    /**
     * Key {@code runner.dontRun.displayName}: {@code Don''t run}.
     * 
     * @return
     *     {@code Don''t run}
     */
    public static String runner_dontRun_displayName() {
        return holder.format("runner.dontRun.displayName");
    }

    /**
     * Key {@code runner.dontRun.displayName}: {@code Don''t run}.
     * 
     * @return
     *     {@code Don''t run}
     */
    public static Localizable _runner_dontRun_displayName() {
        return new Localizable(holder, "runner.dontRun.displayName");
    }

    /**
     * Key {@code variableExistsCondition.displayName}: {@code Environment
     * variable exists}.
     * 
     * @return
     *     {@code Environment variable exists}
     */
    public static String variableExistsCondition_displayName() {
        return holder.format("variableExistsCondition.displayName");
    }

    /**
     * Key {@code variableExistsCondition.displayName}: {@code Environment
     * variable exists}.
     * 
     * @return
     *     {@code Environment variable exists}
     */
    public static Localizable _variableExistsCondition_displayName() {
        return new Localizable(holder, "variableExistsCondition.displayName");
    }

    /**
     * Key {@code stringsMatchCondition.console.args}: {@code Strings match
     * run condition: string 1=[{0}], string 2=[{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Strings match run condition: string 1=[{0}], string 2=[{1}]}
     */
    public static String stringsMatchCondition_console_args(Object arg0, Object arg1) {
        return holder.format("stringsMatchCondition.console.args", arg0, arg1);
    }

    /**
     * Key {@code stringsMatchCondition.console.args}: {@code Strings match
     * run condition: string 1=[{0}], string 2=[{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Strings match run condition: string 1=[{0}], string 2=[{1}]}
     */
    public static Localizable _stringsMatchCondition_console_args(Object arg0, Object arg1) {
        return new Localizable(holder, "stringsMatchCondition.console.args", arg0, arg1);
    }

    /**
     * Key {@code timeCondition.displayName}: {@code Time}.
     * 
     * @return
     *     {@code Time}
     */
    public static String timeCondition_displayName() {
        return holder.format("timeCondition.displayName");
    }

    /**
     * Key {@code timeCondition.displayName}: {@code Time}.
     * 
     * @return
     *     {@code Time}
     */
    public static Localizable _timeCondition_displayName() {
        return new Localizable(holder, "timeCondition.displayName");
    }

    /**
     * Key {@code numericalComparison.console.args}: {@code Numerical
     * comparison: [{0}] {1} [{2}]}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Numerical comparison: [{0}] {1} [{2}]}
     */
    public static String numericalComparison_console_args(Object arg0, Object arg1, Object arg2) {
        return holder.format("numericalComparison.console.args", arg0, arg1, arg2);
    }

    /**
     * Key {@code numericalComparison.console.args}: {@code Numerical
     * comparison: [{0}] {1} [{2}]}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Numerical comparison: [{0}] {1} [{2}]}
     */
    public static Localizable _numericalComparison_console_args(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "numericalComparison.console.args", arg0, arg1, arg2);
    }

    /**
     * Key {@code runner.run.displayName}: {@code Run}.
     * 
     * @return
     *     {@code Run}
     */
    public static String runner_run_displayName() {
        return holder.format("runner.run.displayName");
    }

    /**
     * Key {@code runner.run.displayName}: {@code Run}.
     * 
     * @return
     *     {@code Run}
     */
    public static Localizable _runner_run_displayName() {
        return new Localizable(holder, "runner.run.displayName");
    }

    /**
     * Key {@code dayCondition.selectDays.displayName}: {@code Select days}.
     * 
     * @return
     *     {@code Select days}
     */
    public static String dayCondition_selectDays_displayName() {
        return holder.format("dayCondition.selectDays.displayName");
    }

    /**
     * Key {@code dayCondition.selectDays.displayName}: {@code Select days}.
     * 
     * @return
     *     {@code Select days}
     */
    public static Localizable _dayCondition_selectDays_displayName() {
        return new Localizable(holder, "dayCondition.selectDays.displayName");
    }

    /**
     * Key {@code statusCondition.check}: {@code [Current build status] check
     * if current [{0}] is worse or equals then [{1}] and better or equals
     * then [{2}]}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Current build status] check if current [{0}] is worse or
     *     equals then [{1}] and better or equals then [{2}]}
     */
    public static String statusCondition_check(Object arg0, Object arg1, Object arg2) {
        return holder.format("statusCondition.check", arg0, arg1, arg2);
    }

    /**
     * Key {@code statusCondition.check}: {@code [Current build status] check
     * if current [{0}] is worse or equals then [{1}] and better or equals
     * then [{2}]}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Current build status] check if current [{0}] is worse or
     *     equals then [{1}] and better or equals then [{2}]}
     */
    public static Localizable _statusCondition_check(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "statusCondition.check", arg0, arg1, arg2);
    }

    /**
     * Key {@code neverRun.displayName}: {@code Never}.
     * 
     * @return
     *     {@code Never}
     */
    public static String neverRun_displayName() {
        return holder.format("neverRun.displayName");
    }

    /**
     * Key {@code neverRun.displayName}: {@code Never}.
     * 
     * @return
     *     {@code Never}
     */
    public static Localizable _neverRun_displayName() {
        return new Localizable(holder, "neverRun.displayName");
    }

    /**
     * Key {@code numericalComparison.displayName}: {@code Numerical
     * comparison}.
     * 
     * @return
     *     {@code Numerical comparison}
     */
    public static String numericalComparison_displayName() {
        return holder.format("numericalComparison.displayName");
    }

    /**
     * Key {@code numericalComparison.displayName}: {@code Numerical
     * comparison}.
     * 
     * @return
     *     {@code Numerical comparison}
     */
    public static Localizable _numericalComparison_displayName() {
        return new Localizable(holder, "numericalComparison.displayName");
    }

    /**
     * Key {@code runner.fail.displayName}: {@code Fail the build}.
     * 
     * @return
     *     {@code Fail the build}
     */
    public static String runner_fail_displayName() {
        return holder.format("runner.fail.displayName");
    }

    /**
     * Key {@code runner.fail.displayName}: {@code Fail the build}.
     * 
     * @return
     *     {@code Fail the build}
     */
    public static Localizable _runner_fail_displayName() {
        return new Localizable(holder, "runner.fail.displayName");
    }

    /**
     * Key {@code causeCondition.displayName}: {@code Build Cause}.
     * 
     * @return
     *     {@code Build Cause}
     */
    public static String causeCondition_displayName() {
        return holder.format("causeCondition.displayName");
    }

    /**
     * Key {@code causeCondition.displayName}: {@code Build Cause}.
     * 
     * @return
     *     {@code Build Cause}
     */
    public static Localizable _causeCondition_displayName() {
        return new Localizable(holder, "causeCondition.displayName");
    }

    /**
     * Key {@code runner.stage.prebuild}: {@code prebuild}.
     * 
     * @return
     *     {@code prebuild}
     */
    public static String runner_stage_prebuild() {
        return holder.format("runner.stage.prebuild");
    }

    /**
     * Key {@code runner.stage.prebuild}: {@code prebuild}.
     * 
     * @return
     *     {@code prebuild}
     */
    public static Localizable _runner_stage_prebuild() {
        return new Localizable(holder, "runner.stage.prebuild");
    }

    /**
     * Key {@code booleanCondition.check}: {@code [Boolean condition]
     * checking [{0}] against [{1}] (origin token: {2})}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Boolean condition] checking [{0}] against [{1}] (origin token:
     *     {2})}
     */
    public static String booleanCondition_check(Object arg0, Object arg1, Object arg2) {
        return holder.format("booleanCondition.check", arg0, arg1, arg2);
    }

    /**
     * Key {@code booleanCondition.check}: {@code [Boolean condition]
     * checking [{0}] against [{1}] (origin token: {2})}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Boolean condition] checking [{0}] against [{1}] (origin token:
     *     {2})}
     */
    public static Localizable _booleanCondition_check(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "booleanCondition.check", arg0, arg1, arg2);
    }

    /**
     * Key {@code runner.console.exception}: {@code Exception caught
     * evaluating condition: [{0}], action = [{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Exception caught evaluating condition: [{0}], action = [{1}]}
     */
    public static String runner_console_exception(Object arg0, Object arg1) {
        return holder.format("runner.console.exception", arg0, arg1);
    }

    /**
     * Key {@code runner.console.exception}: {@code Exception caught
     * evaluating condition: [{0}], action = [{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Exception caught evaluating condition: [{0}], action = [{1}]}
     */
    public static Localizable _runner_console_exception(Object arg0, Object arg1) {
        return new Localizable(holder, "runner.console.exception", arg0, arg1);
    }

    /**
     * Key {@code nodeCondition.check}: {@code [Execution node] check if
     * [{0}] is in [{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Execution node] check if [{0}] is in [{1}]}
     */
    public static String nodeCondition_check(Object arg0, Object arg1) {
        return holder.format("nodeCondition.check", arg0, arg1);
    }

    /**
     * Key {@code nodeCondition.check}: {@code [Execution node] check if
     * [{0}] is in [{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Execution node] check if [{0}] is in [{1}]}
     */
    public static Localizable _nodeCondition_check(Object arg0, Object arg1) {
        return new Localizable(holder, "nodeCondition.check", arg0, arg1);
    }

    /**
     * Key {@code fileExistsCondition.check}: {@code [File exists] check if
     * file exists [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [File exists] check if file exists [{0}]}
     */
    public static String fileExistsCondition_check(Object arg0) {
        return holder.format("fileExistsCondition.check", arg0);
    }

    /**
     * Key {@code fileExistsCondition.check}: {@code [File exists] check if
     * file exists [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [File exists] check if file exists [{0}]}
     */
    public static Localizable _fileExistsCondition_check(Object arg0) {
        return new Localizable(holder, "fileExistsCondition.check", arg0);
    }

    /**
     * Key {@code filesMatchCondition.displayName}: {@code Files match}.
     * 
     * @return
     *     {@code Files match}
     */
    public static String filesMatchCondition_displayName() {
        return holder.format("filesMatchCondition.displayName");
    }

    /**
     * Key {@code filesMatchCondition.displayName}: {@code Files match}.
     * 
     * @return
     *     {@code Files match}
     */
    public static Localizable _filesMatchCondition_displayName() {
        return new Localizable(holder, "filesMatchCondition.displayName");
    }

    /**
     * Key {@code numericalComparison.greaterThanOrEqualTo}: {@code >=
     * Greater than or equal to}.
     * 
     * @return
     *     {@code >= Greater than or equal to}
     */
    public static String numericalComparison_greaterThanOrEqualTo() {
        return holder.format("numericalComparison.greaterThanOrEqualTo");
    }

    /**
     * Key {@code numericalComparison.greaterThanOrEqualTo}: {@code >=
     * Greater than or equal to}.
     * 
     * @return
     *     {@code >= Greater than or equal to}
     */
    public static Localizable _numericalComparison_greaterThanOrEqualTo() {
        return new Localizable(holder, "numericalComparison.greaterThanOrEqualTo");
    }

    /**
     * Key {@code nodeCondition.displayName}: {@code Execution node }.
     * 
     * @return
     *     {@code Execution node }
     */
    public static String nodeCondition_displayName() {
        return holder.format("nodeCondition.displayName");
    }

    /**
     * Key {@code nodeCondition.displayName}: {@code Execution node }.
     * 
     * @return
     *     {@code Execution node }
     */
    public static Localizable _nodeCondition_displayName() {
        return new Localizable(holder, "nodeCondition.displayName");
    }

    /**
     * Key {@code alwaysRun.displayName}: {@code Always}.
     * 
     * @return
     *     {@code Always}
     */
    public static String alwaysRun_displayName() {
        return holder.format("alwaysRun.displayName");
    }

    /**
     * Key {@code alwaysRun.displayName}: {@code Always}.
     * 
     * @return
     *     {@code Always}
     */
    public static Localizable _alwaysRun_displayName() {
        return new Localizable(holder, "alwaysRun.displayName");
    }

    /**
     * Key {@code runner.stage.perform}: {@code perform}.
     * 
     * @return
     *     {@code perform}
     */
    public static String runner_stage_perform() {
        return holder.format("runner.stage.perform");
    }

    /**
     * Key {@code runner.stage.perform}: {@code perform}.
     * 
     * @return
     *     {@code perform}
     */
    public static Localizable _runner_stage_perform() {
        return new Localizable(holder, "runner.stage.perform");
    }

    /**
     * Key {@code logic.and.displayName}: {@code And}.
     * 
     * @return
     *     {@code And}
     */
    public static String logic_and_displayName() {
        return holder.format("logic.and.displayName");
    }

    /**
     * Key {@code logic.and.displayName}: {@code And}.
     * 
     * @return
     *     {@code And}
     */
    public static Localizable _logic_and_displayName() {
        return new Localizable(holder, "logic.and.displayName");
    }

    /**
     * Key {@code numericalComparison.notEqualTo}: {@code != Not equal to}.
     * 
     * @return
     *     {@code != Not equal to}
     */
    public static String numericalComparison_notEqualTo() {
        return holder.format("numericalComparison.notEqualTo");
    }

    /**
     * Key {@code numericalComparison.notEqualTo}: {@code != Not equal to}.
     * 
     * @return
     *     {@code != Not equal to}
     */
    public static Localizable _numericalComparison_notEqualTo() {
        return new Localizable(holder, "numericalComparison.notEqualTo");
    }

    /**
     * Key {@code numericalComparison.lessThan}: {@code < Less than}.
     * 
     * @return
     *     {@code < Less than}
     */
    public static String numericalComparison_lessThan() {
        return holder.format("numericalComparison.lessThan");
    }

    /**
     * Key {@code numericalComparison.lessThan}: {@code < Less than}.
     * 
     * @return
     *     {@code < Less than}
     */
    public static Localizable _numericalComparison_lessThan() {
        return new Localizable(holder, "numericalComparison.lessThan");
    }

    /**
     * Key {@code numericalComparison.lessThanOrEqualTo}: {@code <= Less than
     * or equal to}.
     * 
     * @return
     *     {@code <= Less than or equal to}
     */
    public static String numericalComparison_lessThanOrEqualTo() {
        return holder.format("numericalComparison.lessThanOrEqualTo");
    }

    /**
     * Key {@code numericalComparison.lessThanOrEqualTo}: {@code <= Less than
     * or equal to}.
     * 
     * @return
     *     {@code <= Less than or equal to}
     */
    public static Localizable _numericalComparison_lessThanOrEqualTo() {
        return new Localizable(holder, "numericalComparison.lessThanOrEqualTo");
    }

    /**
     * Key {@code filesMatchCondition.console.matched}: {@code Files match
     * condition: Matched [{0}] files}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Files match condition: Matched [{0}] files}
     */
    public static String filesMatchCondition_console_matched(Object arg0) {
        return holder.format("filesMatchCondition.console.matched", arg0);
    }

    /**
     * Key {@code filesMatchCondition.console.matched}: {@code Files match
     * condition: Matched [{0}] files}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Files match condition: Matched [{0}] files}
     */
    public static Localizable _filesMatchCondition_console_matched(Object arg0) {
        return new Localizable(holder, "filesMatchCondition.console.matched", arg0);
    }

}
