/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rolestrategy.casc;

import com.michelin.cio.hudson.plugins.rolestrategy.PermissionTemplate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

@Restricted(value={NoExternalUse.class})
public class PermissionTemplateDefinition
implements Comparable<PermissionTemplateDefinition> {
    private transient PermissionTemplate permissionTemplate;
    private final String name;
    private final Set<String> permissions;

    @DataBoundConstructor
    public PermissionTemplateDefinition(@NonNull String name, @CheckForNull Collection<String> permissions) {
        this.name = name;
        this.permissions = permissions != null ? new HashSet<String>(permissions) : Collections.emptySet();
    }

    public final PermissionTemplate getPermissionTemplate() {
        if (this.permissionTemplate == null) {
            this.permissionTemplate = new PermissionTemplate(this.name, this.permissions);
        }
        return this.permissionTemplate;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    @Override
    public int compareTo(@NonNull PermissionTemplateDefinition o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionTemplateDefinition that = (PermissionTemplateDefinition)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

