/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.AuthorizationType;
import hudson.Functions;
import hudson.Util;
import hudson.model.User;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException2;
import hudson.util.FormValidation;
import org.apache.commons.lang3.StringUtils;
import org.jenkins.ui.symbol.Symbol;
import org.jenkins.ui.symbol.SymbolRequest;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

@Restricted(value={NoExternalUse.class})
class ValidationUtil {
    private static String userSymbol;
    private static String groupSymbol;
    private static String warningSymbol;

    private ValidationUtil() {
    }

    static String formatNonExistentUserGroupValidationResponse(AuthorizationType type, String user, String tooltip) {
        return ValidationUtil.formatNonExistentUserGroupValidationResponse(type, user, tooltip, false);
    }

    static String formatNonExistentUserGroupValidationResponse(AuthorizationType type, String user, String tooltip, boolean alert) {
        return ValidationUtil.formatUserGroupValidationResponse(type, "<span class='rsp-entry-not-found'>" + user + "</span>", tooltip, alert);
    }

    private static String getSymbol(String symbol, String clazzes) {
        SymbolRequest.Builder builder = new SymbolRequest.Builder();
        return Symbol.get((SymbolRequest)builder.withRaw("symbol-" + symbol + "-outline plugin-ionicons-api").withClasses(clazzes).build());
    }

    private static void loadUserSymbol() {
        if (userSymbol == null) {
            userSymbol = ValidationUtil.getSymbol("person", "icon-sm");
        }
    }

    private static void loadGroupSymbol() {
        if (groupSymbol == null) {
            groupSymbol = ValidationUtil.getSymbol("people", "icon-sm");
        }
    }

    private static void loadWarningSymbol() {
        if (warningSymbol == null) {
            warningSymbol = ValidationUtil.getSymbol("warning", "icon-md rsp-table__icon-alert");
        }
    }

    static String formatUserGroupValidationResponse(AuthorizationType type, String user, String tooltip) {
        return ValidationUtil.formatUserGroupValidationResponse(type, user, tooltip, false);
    }

    static String formatUserGroupValidationResponse(AuthorizationType type, String user, String tooltip, boolean alert) {
        String symbol = switch (type) {
            case AuthorizationType.GROUP -> {
                ValidationUtil.loadGroupSymbol();
                yield groupSymbol;
            }
            default -> {
                ValidationUtil.loadUserSymbol();
                yield userSymbol;
            }
        };
        if (alert) {
            ValidationUtil.loadWarningSymbol();
            return String.format("<div tooltip='%s' class='rsp-table__cell'>%s%s%s</div>", tooltip, warningSymbol, symbol, user);
        }
        return String.format("<div tooltip='%s' class='rsp-table__cell'>%s%s</div>", tooltip, symbol, user);
    }

    static FormValidation validateGroup(String groupName, SecurityRealm sr, boolean ambiguous) {
        String escapedSid = Functions.escape((String)groupName);
        try {
            GroupDetails details = sr.loadGroupByGroupname2(groupName, false);
            escapedSid = Util.escape((String)StringUtils.abbreviate((String)details.getDisplayName(), (int)50));
            if (ambiguous) {
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.WARNING, (String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.GROUP, escapedSid, "Group found; but permissions would also be granted to a user of this name", true));
            }
            return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.GROUP, escapedSid, "Group"));
        }
        catch (UserMayOrMayNotExistException2 e) {
            if (ambiguous) {
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.WARNING, (String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.GROUP, escapedSid, "Permissions would also be granted to a user or group of this name", true));
            }
            return FormValidation.ok((String)escapedSid);
        }
        catch (UsernameNotFoundException e) {
        }
        catch (AuthenticationException e) {
            return FormValidation.error((Throwable)e, (String)("Failed to test the validity of the group name " + groupName));
        }
        return null;
    }

    static FormValidation validateUser(String userName, SecurityRealm sr, boolean ambiguous) {
        String escapedSid = Functions.escape((String)userName);
        try {
            sr.loadUserByUsername2(userName);
            User u = User.getById((String)userName, (boolean)true);
            if (userName.equals(u.getFullName())) {
                if (ambiguous) {
                    return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.WARNING, (String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.EITHER, escapedSid, "User found; but permissions would also be granted to a group of this name", true));
                }
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.USER, escapedSid, "User"));
            }
            if (ambiguous) {
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.WARNING, (String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.EITHER, Util.escape((String)StringUtils.abbreviate((String)u.getFullName(), (int)50)), "User " + escapedSid + " found, but permissions would also be granted to a group of this name", true));
            }
            return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.USER, Util.escape((String)StringUtils.abbreviate((String)u.getFullName(), (int)50)), "User " + escapedSid));
        }
        catch (UserMayOrMayNotExistException2 e) {
            if (ambiguous) {
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.WARNING, (String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.EITHER, escapedSid, "Permissions would also be granted to a user or group of this name", true));
            }
            return FormValidation.ok((String)escapedSid);
        }
        catch (UsernameNotFoundException e) {
        }
        catch (AuthenticationException e) {
            return FormValidation.error((Throwable)e, (String)("Failed to test the validity of the user name " + escapedSid));
        }
        return null;
    }
}

