/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.PermissionTemplate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.security.Permission;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.jenkinsci.plugins.rolestrategy.permissions.PermissionHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public final class Role
implements Comparable {
    public static final String GLOBAL_ROLE_PATTERN = ".*";
    private static final Logger LOGGER = Logger.getLogger(Role.class.getName());
    private final String name;
    private final Pattern pattern;
    @CheckForNull
    private final String description;
    @CheckForNull
    private String templateName;
    private Set<Permission> permissions;
    private transient Integer cachedHashCode = null;

    Role(String name, Set<Permission> permissions) {
        this(name, GLOBAL_ROLE_PATTERN, permissions);
    }

    Role(String name, String pattern, Set<Permission> permissions) {
        this(name, Pattern.compile(pattern), permissions, null);
    }

    @DataBoundConstructor
    public Role(@NonNull String name, @CheckForNull String pattern, @CheckForNull Set<String> permissionIds, @CheckForNull String description, String templateName) {
        this(name, Pattern.compile(pattern != null ? pattern : GLOBAL_ROLE_PATTERN), PermissionHelper.fromStrings(permissionIds, true), description, templateName);
    }

    public Role(@NonNull String name, @CheckForNull String pattern, @CheckForNull Set<String> permissionIds, @CheckForNull String description) {
        this(name, Pattern.compile(pattern != null ? pattern : GLOBAL_ROLE_PATTERN), PermissionHelper.fromStrings(permissionIds, true), description, "");
    }

    public Role(String name, Pattern pattern, Set<Permission> permissions, @CheckForNull String description) {
        this(name, pattern, permissions, description, "");
    }

    public Role(String name, Pattern pattern, Set<Permission> permissions, @CheckForNull String description, String templateName) {
        this.name = name;
        this.pattern = pattern;
        this.description = description;
        this.templateName = templateName;
        this.permissions = new HashSet<Permission>();
        for (Permission perm : permissions) {
            if (perm == null) {
                LOGGER.log(Level.WARNING, "Found some null permission(s) in role " + this.name, new IllegalArgumentException());
                continue;
            }
            this.permissions.add(perm);
        }
        this.cachedHashCode = this._hashCode();
    }

    public void setTemplateName(@CheckForNull String templateName) {
        this.templateName = templateName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getName() {
        return this.name;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Set<Permission> getPermissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    private synchronized void setPermissions(Set<Permission> permissions) {
        this.permissions = new HashSet<Permission>(permissions);
        this.cachedHashCode = this._hashCode();
    }

    @Deprecated
    public void refreshPermissionsFromTemplate(Collection<PermissionTemplate> permissionTemplates) {
        if (Util.fixEmptyAndTrim((String)this.templateName) != null) {
            boolean found = false;
            for (PermissionTemplate pt : permissionTemplates) {
                if (!pt.getName().equals(this.templateName)) continue;
                this.setPermissions(pt.getPermissions());
                found = true;
                break;
            }
            if (!found) {
                this.templateName = null;
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    public void refreshPermissionsFromTemplate(@CheckForNull PermissionTemplate permissionTemplate) {
        if (permissionTemplate != null && this.templateName != null && this.templateName.equals(permissionTemplate.getName())) {
            this.setPermissions(permissionTemplate.getPermissions());
        }
    }

    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    public Boolean hasPermission(Permission permission) {
        return this.permissions.contains(permission);
    }

    public Boolean hasAnyPermission(Set<Permission> permissions) {
        return CollectionUtils.containsAny(this.permissions, permissions);
    }

    public int compareTo(@NonNull Object o) {
        Objects.requireNonNull(o);
        if (o instanceof Role) {
            return this.name.compareTo(((Role)o).name);
        }
        return -1;
    }

    public int hashCode() {
        if (this.cachedHashCode == null) {
            this.cachedHashCode = this._hashCode();
        }
        return this.cachedHashCode;
    }

    private int _hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 53 * hash + (this.pattern != null ? this.pattern.hashCode() : 0);
        hash = 53 * hash + this.permissions.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Role other = (Role)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.pattern, other.pattern)) {
            return false;
        }
        return Objects.equals(this.permissions, other.permissions);
    }
}

