/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.Messages;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleBasedAuthorizationStrategy;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleStrategyConfig;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.RootAction;
import hudson.security.Permission;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerProxy;

@Extension
public class RoleStrategyRootAction
implements RootAction,
StaplerProxy {
    @CheckForNull
    public String getIconFileName() {
        Jenkins jenkins = Jenkins.get();
        if (!(jenkins.getAuthorizationStrategy() instanceof RoleBasedAuthorizationStrategy)) {
            return null;
        }
        boolean hasRoleAdmin = jenkins.hasAnyPermission(new Permission[]{RoleBasedAuthorizationStrategy.AGENT_ROLES_ADMIN, RoleBasedAuthorizationStrategy.ITEM_ROLES_ADMIN});
        boolean hasSystemRead = jenkins.hasPermission(Jenkins.SYSTEM_READ);
        if (hasRoleAdmin && !hasSystemRead) {
            return "symbol-lock-closed-outline plugin-ionicons-api";
        }
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        return Messages.RoleBasedAuthorizationStrategy_ManageAndAssign();
    }

    @CheckForNull
    public String getUrlName() {
        return "role-strategy";
    }

    public Object getTarget() {
        Jenkins.get().checkAnyPermission(RoleBasedAuthorizationStrategy.ADMINISTER_AND_SOME_ROLES_ADMIN);
        return RoleStrategyConfig.get();
    }
}

