/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.reverse_proxy_auth.auth;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.reverse_proxy_auth.ReverseProxySearchTemplate;
import org.jenkinsci.plugins.reverse_proxy_auth.auth.ReverseProxyAuthoritiesPopulator;
import org.jenkinsci.plugins.reverse_proxy_auth.data.UserSearchTemplate;
import org.jenkinsci.plugins.reverse_proxy_auth.model.ReverseProxyUserDetails;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.Assert;

public class DefaultReverseProxyAuthoritiesPopulator
implements ReverseProxyAuthoritiesPopulator {
    private static final Logger logger = Logger.getLogger(DefaultReverseProxyAuthoritiesPopulator.class.getName());
    private GrantedAuthority defaultRole;
    private final ReverseProxySearchTemplate reverseProxyTemplate;
    private String rolePrefix = "ROLE_";
    private boolean convertToUpperCase = true;
    @CheckForNull
    protected Hashtable<String, Collection<? extends GrantedAuthority>> authContext;

    public DefaultReverseProxyAuthoritiesPopulator(@CheckForNull Hashtable<String, Collection<? extends GrantedAuthority>> authContext) {
        this.authContext = authContext != null ? new Hashtable<String, Collection<? extends GrantedAuthority>>(authContext) : null;
        this.reverseProxyTemplate = new ReverseProxySearchTemplate();
    }

    protected Set<GrantedAuthority> getAdditionalRoles(ReverseProxyUserDetails reverseProxyUser) {
        return null;
    }

    @Override
    public final Collection<? extends GrantedAuthority> getGrantedAuthorities(ReverseProxyUserDetails userDetails) {
        String username = userDetails.getUsername();
        Set<GrantedAuthority> roles = this.getGroupMembershipRoles(username);
        Set<GrantedAuthority> extraRoles = this.getAdditionalRoles(userDetails);
        if (extraRoles != null) {
            roles.addAll(extraRoles);
        }
        if (this.defaultRole != null) {
            roles.add(this.defaultRole);
        }
        return roles;
    }

    public Set<GrantedAuthority> getGroupMembershipRoles(String username) {
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        Collection<? extends GrantedAuthority> contextAuthorities = this.authContext != null ? this.authContext.get(username) : null;
        UserSearchTemplate searchTemplate = new UserSearchTemplate(username);
        Set<String> userRoles = this.reverseProxyTemplate.searchForSingleAttributeValues(searchTemplate, contextAuthorities);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Roles from search: " + String.valueOf(userRoles));
        }
        for (String role : userRoles) {
            if (this.convertToUpperCase) {
                role = role.toUpperCase();
            }
            authorities.add((GrantedAuthority)new SimpleGrantedAuthority(this.rolePrefix + role));
        }
        return authorities;
    }

    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }

    public void setDefaultRole(String defaultRole) {
        Assert.notNull((Object)defaultRole, (String)"The defaultRole property cannot be set to null");
        this.defaultRole = new SimpleGrantedAuthority(defaultRole);
    }

    public void setRolePrefix(String rolePrefix) {
        Assert.notNull((Object)rolePrefix, (String)"rolePrefix must not be null");
        this.rolePrefix = rolePrefix;
    }
}

