/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.reverse_proxy_auth.data;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;

public abstract class SearchTemplate {
    protected String userOrGroup;

    public SearchTemplate(String userOrGroup) {
        this.userOrGroup = userOrGroup;
    }

    public abstract Set<String> processAuthorities(Collection<? extends GrantedAuthority> var1);

    @NonNull
    protected Set<String> doProcess(@CheckForNull Collection<? extends GrantedAuthority> authorities) {
        HashSet<String> authorityValues = new HashSet<String>();
        if (authorities != null) {
            for (GrantedAuthority grantedAuthority : authorities) {
                String authority = grantedAuthority.getAuthority();
                if (authority.toUpperCase().startsWith("CN=")) {
                    int index = authority.indexOf(44);
                    String groupName = index > 0 ? authority.substring(3, authority.indexOf(44)) : authority.substring(3, authority.length());
                    authorityValues.add(groupName);
                    continue;
                }
                authorityValues.add(authority);
            }
        }
        return authorityValues;
    }
}

