/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.reverse_proxy_auth.service;

import hudson.security.UserMayOrMayNotExistException2;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.directory.Attributes;
import jenkins.util.SetContextClassLoader;
import org.apache.commons.collections.map.LRUMap;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapUserDetails;
import org.springframework.security.ldap.userdetails.LdapUserDetailsImpl;

public class ProxyLDAPUserDetailsService
implements UserDetailsService {
    private static final Logger LOGGER = Logger.getLogger(ProxyLDAPUserDetailsService.class.getName());
    private static final int RETRY_TIMES = 3;
    private static final long MAX_WAIT_INTERVAL = 5000L;
    public final LdapUserSearch ldapSearch;
    public final LdapAuthoritiesPopulator authoritiesPopulator;
    private final LRUMap attributesCache = new LRUMap(32);

    public ProxyLDAPUserDetailsService(LdapUserSearch ldapSearch, LdapAuthoritiesPopulator authoritiesPopulator) {
        this.ldapSearch = ldapSearch;
        this.authoritiesPopulator = authoritiesPopulator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        int retries = 0;
        while (retries < 3) {
            LdapUserDetails ldapUserDetails;
            SetContextClassLoader sccl = new SetContextClassLoader(ProxyLDAPUserDetailsService.class);
            try {
                DirContextOperations ldapUser = this.ldapSearch.searchForUser(username);
                LdapUserDetailsImpl.Essence user = new LdapUserDetailsImpl.Essence(ldapUser);
                user.setUsername(username);
                user.setDn(ldapUser.getNameInNamespace());
                Attributes v = ldapUser.getAttributes();
                LRUMap lRUMap = this.attributesCache;
                synchronized (lRUMap) {
                    Attributes vv = (Attributes)this.attributesCache.get((Object)v);
                    if (vv == null) {
                        this.attributesCache.put((Object)v, (Object)v);
                    } else {
                        v = vv;
                    }
                }
                Collection extraAuthorities = this.authoritiesPopulator.getGrantedAuthorities(ldapUser, username);
                for (GrantedAuthority extraAuthority : extraAuthorities) {
                    user.addAuthority(extraAuthority);
                }
                ldapUserDetails = user.createUserDetails();
            }
            catch (Throwable ldapUser) {
                try {
                    try {
                        sccl.close();
                    }
                    catch (Throwable throwable) {
                        ldapUser.addSuppressed(throwable);
                    }
                    throw ldapUser;
                }
                catch (AuthenticationServiceException ldapEx) {
                    long waitTime = Math.min(this.getWaitTimeExp(retries), 5000L);
                    String msg = String.format("Failed to search LDAP for username %s, will retry after waiting for %d milliseconds", username, waitTime);
                    LOGGER.log(Level.WARNING, msg, ldapEx);
                    try {
                        Thread.sleep(waitTime);
                    }
                    catch (InterruptedException intEx) {
                        LOGGER.log(Level.WARNING, "Thread was interrupted while sleeping!");
                    }
                    ++retries;
                }
            }
            sccl.close();
            return ldapUserDetails;
        }
        throw new UserMayOrMayNotExistException2("Failed to search LDAP for user after all the retries.");
    }

    private long getWaitTimeExp(int retryCount) {
        long waitTime = (long)Math.pow(2.0, retryCount) * 1000L;
        return waitTime;
    }
}

