/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.reverse_proxy_auth.service;

import hudson.Util;
import hudson.security.SecurityRealm;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jenkins.util.SetContextClassLoader;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;

public class ProxyLDAPAuthoritiesPopulator
extends DefaultLdapAuthoritiesPopulator {
    private String rolePrefix = "ROLE_";
    private boolean convertToUpperCase = true;

    public ProxyLDAPAuthoritiesPopulator(ContextSource contextSource, String groupSearchBase) {
        super(contextSource, Util.fixNull((String)groupSearchBase));
        super.setRolePrefix("");
        super.setConvertToUpperCase(false);
    }

    protected Set<GrantedAuthority> getAdditionalRoles(DirContextOperations user, String username) {
        return Collections.singleton(SecurityRealm.AUTHENTICATED_AUTHORITY2);
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }

    public Set<GrantedAuthority> getGroupMembershipRoles(String userDn, String username) {
        Set names;
        try (SetContextClassLoader sccl = new SetContextClassLoader(ProxyLDAPAuthoritiesPopulator.class);){
            names = super.getGroupMembershipRoles(userDn, username);
        }
        HashSet<GrantedAuthority> r = new HashSet<GrantedAuthority>(names.size() * 2);
        r.addAll(names);
        for (GrantedAuthority ga : names) {
            String role = ga.getAuthority();
            if (this.convertToUpperCase) {
                role = role.toUpperCase();
            }
            r.add((GrantedAuthority)new SimpleGrantedAuthority(this.rolePrefix + role));
        }
        return r;
    }
}

