/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.reverse_proxy_auth.auth;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.reverse_proxy_auth.auth.ReverseProxyAuthenticator;
import org.jenkinsci.plugins.reverse_proxy_auth.auth.ReverseProxyAuthoritiesPopulator;
import org.jenkinsci.plugins.reverse_proxy_auth.model.ReverseProxyUserDetails;
import org.springframework.dao.DataAccessException;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ReverseProxyAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    private static final Logger logger = Logger.getLogger(ReverseProxyAuthenticationProvider.class.getName());
    private ReverseProxyAuthenticator authenticator;
    private ReverseProxyAuthoritiesPopulator authoritiesPopulator;
    private boolean includeDetailsObject = true;

    public ReverseProxyAuthenticationProvider(ReverseProxyAuthenticator authenticator, ReverseProxyAuthoritiesPopulator authoritiesPopulator) {
        this.setAuthenticator(authenticator);
        this.setAuthoritiesPopulator(authoritiesPopulator);
    }

    public ReverseProxyAuthenticationProvider(ReverseProxyAuthenticator authenticator) {
        this.setAuthenticator(authenticator);
        this.setAuthoritiesPopulator(new NullAuthoritiesPopulator());
    }

    private void setAuthenticator(ReverseProxyAuthenticator authenticator) {
        Assert.notNull((Object)authenticator, (String)"An Authenticator must be supplied");
        this.authenticator = authenticator;
    }

    private ReverseProxyAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    private void setAuthoritiesPopulator(ReverseProxyAuthoritiesPopulator authoritiesPopulator) {
        Assert.notNull((Object)authoritiesPopulator, (String)"An AuthoritiesPopulator must be supplied");
        this.authoritiesPopulator = authoritiesPopulator;
    }

    protected ReverseProxyAuthoritiesPopulator getAuthoritiesPopulator() {
        return this.authoritiesPopulator;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
    }

    protected UserDetails createUserDetails(ReverseProxyUserDetails user, String username, String password) {
        user.setUsername(username);
        Collection<? extends GrantedAuthority> extraAuthorities = this.getAuthoritiesPopulator().getGrantedAuthorities(user);
        user.setAuthorities(extraAuthorities);
        return user;
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        if (!StringUtils.hasLength((String)username)) {
            throw new BadCredentialsException("Empty Username");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Retrieving user " + username);
        }
        String password = (String)authentication.getCredentials();
        try {
            ReverseProxyUserDetails revProxyU = this.getAuthenticator().authenticate(username, password);
            return this.createUserDetails(revProxyU, username, password);
        }
        catch (DataAccessException ldapAccessFailure) {
            throw new AuthenticationServiceException(ldapAccessFailure.getMessage(), (Throwable)ldapAccessFailure);
        }
    }

    public boolean isIncludeDetailsObject() {
        return this.includeDetailsObject;
    }

    public void setIncludeDetailsObject(boolean includeDetailsObject) {
        this.includeDetailsObject = includeDetailsObject;
    }

    private static class NullAuthoritiesPopulator
    implements ReverseProxyAuthoritiesPopulator {
        private NullAuthoritiesPopulator() {
        }

        @Override
        public Collection<? extends GrantedAuthority> getGrantedAuthorities(ReverseProxyUserDetails userDetails) {
            return Collections.emptySet();
        }
    }
}

