/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.reverse_proxy_auth.data;

import hudson.model.User;
import hudson.model.UserProperty;
import hudson.tasks.Mailer;
import java.io.IOException;

public class ForwardedUserData {
    private static final String NULL_HEADER = "(null)";
    private String email;
    private String displayName;

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean update(User user) {
        boolean toReturn = false;
        if (this.updateDisplayName(user) || this.updateEmail(user)) {
            toReturn = true;
            try {
                user.save();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return toReturn;
    }

    private boolean updateDisplayName(User user) {
        boolean toReturn = false;
        if (ForwardedUserData.isNotNullHeader(this.displayName) && !this.displayName.equals(user.getFullName())) {
            user.setFullName(this.displayName);
            toReturn = true;
        }
        return toReturn;
    }

    private boolean updateEmail(User user) {
        Mailer.UserProperty emailProp;
        boolean toReturn = false;
        if (ForwardedUserData.isNotNullHeader(this.email) && ((emailProp = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)) == null || !this.email.equals(emailProp.getConfiguredAddress()))) {
            emailProp = new Mailer.UserProperty(this.email);
            try {
                user.addProperty((UserProperty)emailProp);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            toReturn = true;
        }
        return toReturn;
    }

    private static boolean isNotNullHeader(String value) {
        return value != null && !value.equals(NULL_HEADER);
    }
}

