/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.resourcedisposer;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.XmlFile;
import hudson.model.AdministrativeMonitor;
import hudson.model.PeriodicWork;
import hudson.util.DaemonThreadFactory;
import hudson.util.ExceptionCatchingThreadFactory;
import hudson.util.HttpResponses;
import hudson.util.NamingThreadFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.resourcedisposer.Disposable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class AsyncResourceDisposer
extends AdministrativeMonitor
implements Serializable {
    private static final long serialVersionUID = -1707941450072465346L;
    private static final Logger LOGGER = Logger.getLogger(AsyncResourceDisposer.class.getName());
    static final int MAXIMUM_POOL_SIZE = 10;
    private static final ExceptionCatchingThreadFactory THREAD_FACTORY = new ExceptionCatchingThreadFactory((ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), "AsyncResourceDisposer.worker"));
    private transient ExecutorService worker;
    @NonNull
    private final Set<WorkItem> backlog = Collections.newSetFromMap(new ConcurrentHashMap());

    @NonNull
    public static AsyncResourceDisposer get() {
        return (AsyncResourceDisposer)ExtensionList.lookupSingleton(AsyncResourceDisposer.class);
    }

    public AsyncResourceDisposer() {
        super("AsyncResourceDisposer");
        this.load();
        this.readResolve();
    }

    private Object readResolve() {
        if (this.worker == null) {
            this.worker = Executors.newFixedThreadPool(10, (ThreadFactory)THREAD_FACTORY);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Set<WorkItem> getBacklog() {
        Set<WorkItem> set = this.backlog;
        synchronized (set) {
            return new HashSet<WorkItem>(this.backlog);
        }
    }

    public String getDisplayName() {
        return "Asynchronous resource disposer";
    }

    public boolean isActivated() {
        if (this.backlog.isEmpty()) {
            return false;
        }
        long threshold = System.currentTimeMillis() - 14400000L;
        for (WorkItem workItem : this.getBacklog()) {
            if (workItem.getLastState().equals(Disposable.State.PURGED) || workItem.registered.getTime() >= threshold) continue;
            return true;
        }
        return false;
    }

    public void dispose(Disposable ... disposables) {
        boolean modified = false;
        for (Disposable disposable : disposables) {
            WorkItem item = new WorkItem(this, disposable);
            boolean added = this.backlog.add(item);
            if (!added) continue;
            modified = true;
            this.worker.submit(item);
        }
        if (modified) {
            this.persist();
        }
    }

    public void dispose(@NonNull Iterable<? extends Disposable> disposables) {
        boolean modified = false;
        for (Disposable disposable : disposables) {
            WorkItem item = new WorkItem(this, disposable);
            boolean added = this.backlog.add(item);
            if (!added) continue;
            modified = true;
            this.worker.submit(item);
        }
        if (modified) {
            this.persist();
        }
    }

    @Restricted(value={DoNotUse.class})
    @RequirePOST
    public HttpResponse doStopTracking(@QueryParameter int id, StaplerResponse2 rsp) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        for (WorkItem workItem : this.getBacklog()) {
            if (workItem.getId() != id) continue;
            boolean removed = this.backlog.remove(workItem);
            if (!removed) break;
            this.persist();
            break;
        }
        return HttpResponses.redirectViaContextPath((String)this.getUrl());
    }

    private void persist() {
        try {
            this.getConfigFile().write((Object)this);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to store AsyncResourceDisposer history", e);
        }
    }

    private void load() {
        XmlFile file = this.getConfigFile();
        if (file.exists()) {
            try {
                file.unmarshal((Object)this);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Unable to load AsyncResourceDisposer history", e);
            }
        }
    }

    private XmlFile getConfigFile() {
        Jenkins instance = Jenkins.getInstanceOrNull();
        if (instance == null) {
            throw new IllegalStateException();
        }
        return new XmlFile(Jenkins.XSTREAM, new File(new File(instance.root, this.getClass().getCanonicalName() + ".xml").getAbsolutePath()));
    }

    @VisibleForTesting
    public void reschedule() {
        if (this.backlog.isEmpty()) {
            return;
        }
        this.persist();
        for (WorkItem workItem : this.getBacklog()) {
            if (workItem.inProgress) {
                LOGGER.log(Level.FINE, "{0} is in progress", workItem);
                continue;
            }
            LOGGER.log(Level.FINE, "Rescheduling {0}", workItem);
            this.worker.submit(workItem);
        }
    }

    @VisibleForTesting
    void rescheduleAndWait() throws InterruptedException {
        if (this.backlog.isEmpty()) {
            return;
        }
        ArrayList<Future> futures = new ArrayList<Future>();
        for (WorkItem workItem : this.getBacklog()) {
            if (workItem.inProgress) {
                LOGGER.log(Level.FINE, "{0} is in progress", workItem);
                continue;
            }
            LOGGER.log(Level.FINER, "Rescheduling {0}", workItem);
            Future<?> f = this.worker.submit(workItem);
            futures.add(f);
        }
        while (!futures.isEmpty()) {
            futures.removeIf(future -> future.isDone() || future.isCancelled());
            Thread.sleep(100L);
        }
    }

    @VisibleForTesting
    public Future<WorkItem> disposeAndWait(Disposable disposable) {
        WorkItem item = new WorkItem(this, disposable);
        this.backlog.add(item);
        Future<WorkItem> future = this.worker.submit(item, item);
        this.persist();
        return future;
    }

    @VisibleForTesting
    public void reset() {
        this.backlog.clear();
    }

    @Restricted(value={NoExternalUse.class})
    public static final class WorkItem
    implements Runnable,
    Serializable {
        private static final long serialVersionUID = 1L;
        @NonNull
        private final AsyncResourceDisposer disposer;
        @NonNull
        private Disposable disposable;
        @NonNull
        private final Date registered = new Date();
        @NonNull
        private volatile transient Disposable.State lastState = Disposable.State.TO_DISPOSE;
        private volatile transient boolean inProgress;
        @CheckForNull
        private String disposableInfo;

        private WorkItem(@NonNull AsyncResourceDisposer disposer, @NonNull Disposable disposable) {
            this.disposer = disposer;
            this.disposable = disposable;
            this.readResolve();
        }

        @NonNull
        public Disposable getDisposable() {
            return this.disposable;
        }

        @NonNull
        public Date getRegistered() {
            return new Date(this.registered.getTime());
        }

        @NonNull
        public Disposable.State getLastState() {
            return this.lastState;
        }

        public int getId() {
            return System.identityHashCode(this);
        }

        public String toString() {
            return "Disposer work item: " + this.disposable.getDisplayName();
        }

        @Override
        public void run() {
            if (this.inProgress) {
                return;
            }
            this.inProgress = true;
            try {
                this.lastState = this.disposable.dispose();
                if (this.lastState == Disposable.State.PURGED) {
                    this.disposer.backlog.remove(this);
                    if (this.disposer.backlog.isEmpty()) {
                        this.disposer.persist();
                    }
                }
            }
            catch (Throwable ex) {
                this.lastState = new Disposable.State.Thrown(ex);
            }
            finally {
                this.inProgress = false;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorkItem workItem = (WorkItem)o;
            return this.disposable.equals(workItem.disposable);
        }

        public int hashCode() {
            return this.disposable.hashCode();
        }

        @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
        private Object readResolve() {
            this.inProgress = false;
            this.lastState = Disposable.State.TO_DISPOSE;
            if (this.disposable == null) {
                String msg = "Unable to deserialize '" + this.disposableInfo + "'. The resource was probably leaked.";
                LOGGER.warning(msg);
                this.disposable = new FailedToDeserialize(msg);
            }
            this.disposableInfo = this.disposable.getClass().getName() + ":" + this.disposable.getDisplayName();
            return this;
        }

        private static class FailedToDeserialize
        implements Disposable {
            private static final long serialVersionUID = 5249985901013332487L;
            private final String msg;

            FailedToDeserialize(String msg) {
                this.msg = msg;
            }

            @Override
            @NonNull
            public Disposable.State dispose() {
                return Disposable.State.PURGED;
            }

            @Override
            @NonNull
            public String getDisplayName() {
                return this.msg;
            }
        }
    }

    @Restricted(value={DoNotUse.class})
    @Extension
    public static class Scheduler
    extends PeriodicWork {
        protected void doRun() {
            AsyncResourceDisposer.get().reschedule();
        }

        public long getRecurrencePeriod() {
            return 60000L;
        }

        public String toString() {
            return "AsyncResourceDisposer.Maintainer";
        }
    }
}

