/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.resourcedisposer;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;

public interface Disposable
extends Serializable {
    @NonNull
    public State dispose() throws Throwable;

    @NonNull
    public String getDisplayName();

    public static abstract class State
    implements Serializable {
        private static final long serialVersionUID = -2908370512742097295L;
        @NonNull
        public static final State TO_DISPOSE = new ToDispose();
        @NonNull
        public static final State PURGED = new Purged();
        private final String displayName;

        protected State(String displayName) {
            this.displayName = displayName;
        }

        @NonNull
        public String getDisplayName() {
            return this.displayName;
        }

        public static final class ToDispose
        extends State {
            private static final long serialVersionUID = -374257846640988541L;

            private ToDispose() {
                super("To dispose");
            }
        }

        public static final class Purged
        extends State {
            private static final long serialVersionUID = -3295110479777639361L;

            private Purged() {
                super("Purged successfully");
            }
        }

        public static final class Failed
        extends State {
            private static final long serialVersionUID = 2065789176411056177L;

            public Failed(@NonNull String cause) {
                super(cause);
            }
        }

        public static final class Thrown
        extends State {
            private static final long serialVersionUID = -605474825355714673L;
            @NonNull
            private final Throwable cause;

            public Thrown(@NonNull Throwable cause) {
                super(cause.getMessage());
                this.cause = cause;
            }

            @NonNull
            public Throwable getCause() {
                return this.cause;
            }
        }
    }
}

