/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pubsub.listeners;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.listeners.ItemListener;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.pubsub.EventProps;
import org.jenkinsci.plugins.pubsub.Events;
import org.jenkinsci.plugins.pubsub.JobMessage;
import org.jenkinsci.plugins.pubsub.Message;
import org.jenkinsci.plugins.pubsub.MessageException;
import org.jenkinsci.plugins.pubsub.PubsubBus;
import org.jenkinsci.plugins.pubsub.SimpleMessage;

@Extension
public class SyncJobCRUDListener
extends ItemListener {
    private static final Logger LOGGER = Logger.getLogger(SyncJobCRUDListener.class.getName());

    public void onCreated(Item item) {
        this.publish(item, Events.JobChannel.job_crud_created, null);
    }

    public void onDeleted(Item item) {
        this.publish(item, Events.JobChannel.job_crud_deleted, null);
    }

    public void onRenamed(Item item, String oldName, String newName) {
        this.publish(item, Events.JobChannel.job_crud_renamed, (Properties)((SimpleMessage)new SimpleMessage().set(EventProps.Item.item_rename_before, oldName)).set(EventProps.Item.item_rename_after, newName));
    }

    public void onUpdated(Item item) {
        this.publish(item, Events.JobChannel.job_crud_updated, null);
    }

    private void publish(Item item, Events.JobChannel event, Properties properties) {
        if (item instanceof Job) {
            try {
                Object message = new JobMessage(item).setEventName(event);
                if (properties != null) {
                    ((Properties)message).putAll((Map<?, ?>)properties);
                }
                PubsubBus.getBus().publish((Message)message);
            }
            catch (MessageException e) {
                LOGGER.log(Level.WARNING, "Error publishing Job CRUD event.", e);
            }
        }
    }
}

