/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.publishoverdropbox.impl.step;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.DaemonThreadFactory;
import hudson.util.NamingThreadFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import jenkins.plugins.publish_over.BPBuildEnv;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPHostConfiguration;
import jenkins.plugins.publish_over.BPHostConfigurationAccess;
import jenkins.plugins.publish_over.BPInstanceConfig;
import jenkins.util.BuildListenerAdapter;
import org.jenkinsci.plugins.publishoverdropbox.domain.DropboxClient;
import org.jenkinsci.plugins.publishoverdropbox.impl.DropboxPublisher;
import org.jenkinsci.plugins.publishoverdropbox.impl.DropboxPublisherPlugin;
import org.jenkinsci.plugins.publishoverdropbox.impl.Messages;
import org.jenkinsci.plugins.publishoverdropbox.impl.step.DropboxPublishStep;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public class DropboxPublishStepExecution
extends StepExecution
implements BPHostConfigurationAccess<DropboxClient, Object> {
    private static final long serialVersionUID = 1L;
    private static ExecutorService executorService;
    @StepContextParameter
    private transient TaskListener taskListener;
    @StepContextParameter
    private transient Run run;
    @StepContextParameter
    private transient FilePath workspace;
    @StepContextParameter
    private transient EnvVars envVars;
    @Inject
    private transient DropboxPublishStep step;
    private transient boolean canceled;
    private transient Throwable cancelCause;

    public boolean start() throws Exception {
        DropboxPublishStepExecution.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                DropboxPublisher publisher = new DropboxPublisher(DropboxPublishStepExecution.this.step.getConfigName(), false, DropboxPublishStepExecution.this.step.getTransfers(), true, true, null, null);
                ArrayList<DropboxPublisher> publishers = new ArrayList<DropboxPublisher>(Arrays.asList(publisher));
                BuildListener listener = BuildListenerAdapter.wrap((TaskListener)DropboxPublishStepExecution.this.taskListener);
                String consolePrefix = Messages.console_message_prefix();
                BPBuildEnv currentBuildEnv = new BPBuildEnv((TreeMap)DropboxPublishStepExecution.this.envVars, DropboxPublishStepExecution.this.workspace, DropboxPublishStepExecution.this.run.getTimestamp());
                BPBuildInfo buildInfo = new BPBuildInfo((TaskListener)listener, consolePrefix, Jenkins.get().getRootPath(), currentBuildEnv, null);
                BPInstanceConfig delegate = new BPInstanceConfig(publishers, false, false, false, null, null);
                delegate.setHostConfigurationAccess((BPHostConfigurationAccess)DropboxPublishStepExecution.this);
                try {
                    Result result = delegate.perform(buildInfo);
                    if (result != Result.SUCCESS) {
                        DropboxPublishStepExecution.this.setCanceled(true);
                        DropboxPublishStepExecution.this.cancelCause = new Exception(result.toString());
                    }
                }
                catch (Exception e) {
                    DropboxPublishStepExecution.this.setCanceled(true);
                    DropboxPublishStepExecution.this.cancelCause = e;
                }
                if (DropboxPublishStepExecution.this.isCanceled()) {
                    DropboxPublishStepExecution.this.getContext().onFailure(DropboxPublishStepExecution.this.cancelCause);
                } else {
                    DropboxPublishStepExecution.this.getContext().onSuccess(null);
                }
            }
        });
        return false;
    }

    public void stop(@Nonnull Throwable cause) throws Exception {
        this.cancelCause = cause;
        this.setCanceled(true);
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private static synchronized ExecutorService getExecutorService() {
        if (executorService == null) {
            executorService = Executors.newCachedThreadPool((ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), "org.jenkinsci.plugins.publishoverdropbox.impl.step.DropboxPublishStepExecution"));
        }
        return executorService;
    }

    public BPHostConfiguration<DropboxClient, Object> getConfiguration(String name) {
        DropboxPublisherPlugin.Descriptor pluginDescriptor = (DropboxPublisherPlugin.Descriptor)Jenkins.get().getDescriptorByType(DropboxPublisherPlugin.Descriptor.class);
        return pluginDescriptor.getConfiguration(this.step.getConfigName());
    }
}

