/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.publishoverdropbox.impl.step;

import hudson.Extension;
import hudson.Util;
import java.util.ArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.publishoverdropbox.impl.DropboxPublisherPlugin;
import org.jenkinsci.plugins.publishoverdropbox.impl.DropboxTransfer;
import org.jenkinsci.plugins.publishoverdropbox.impl.step.DropboxPublishStepExecution;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DropboxPublishStep
extends AbstractStepImpl {
    private final String sourceFiles;
    private final String remoteDirectory;
    private final String configName;
    private String excludes;
    private String removePrefix;
    private boolean remoteDirectorySDF;
    private boolean flatten;
    private boolean cleanRemote;
    private boolean pruneRoot;
    private int pruneDays;

    @DataBoundConstructor
    public DropboxPublishStep(String sourceFiles, String remoteDirectory, String configName) {
        this.sourceFiles = sourceFiles;
        this.remoteDirectory = remoteDirectory;
        this.configName = configName;
    }

    public String getSourceFiles() {
        return this.sourceFiles;
    }

    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public String getConfigName() {
        return this.configName;
    }

    public ArrayList<DropboxTransfer> getTransfers() {
        ArrayList<DropboxTransfer> tranfers = new ArrayList<DropboxTransfer>();
        tranfers.add(new DropboxTransfer(this.sourceFiles, this.excludes, this.remoteDirectory, this.removePrefix, this.remoteDirectorySDF, this.flatten, this.cleanRemote, this.pruneRoot, this.pruneDays));
        return tranfers;
    }

    public String getExcludes() {
        return this.excludes;
    }

    @DataBoundSetter
    public void setExcludes(@CheckForNull String excludes) {
        this.excludes = Util.fixNull((String)excludes);
    }

    public String getRemovePrefix() {
        return this.removePrefix;
    }

    @DataBoundSetter
    public void setRemovePrefix(@CheckForNull String removePrefix) {
        this.removePrefix = Util.fixNull((String)removePrefix);
    }

    public boolean isRemoteDirectorySDF() {
        return this.remoteDirectorySDF;
    }

    @DataBoundSetter
    public void setRemoteDirectorySDF(boolean remoteDirectorySDF) {
        this.remoteDirectorySDF = remoteDirectorySDF;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    @DataBoundSetter
    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public boolean isCleanRemote() {
        return this.cleanRemote;
    }

    @DataBoundSetter
    public void setCleanRemote(boolean cleanRemote) {
        this.cleanRemote = cleanRemote;
    }

    public boolean isPruneRoot() {
        return this.pruneRoot;
    }

    @DataBoundSetter
    public void setPruneRoot(boolean pruneRoot) {
        this.pruneRoot = pruneRoot;
    }

    public int getPruneDays() {
        return this.pruneDays;
    }

    @DataBoundSetter
    public void setPruneDays(int pruneDays) {
        this.pruneDays = pruneDays > 0 ? pruneDays : 0;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(DropboxPublishStepExecution.class);
        }

        public String getFunctionName() {
            return "dropbox";
        }

        @Nonnull
        public String getDisplayName() {
            return "Publish to Dropbox folder";
        }

        public DropboxPublisherPlugin.Descriptor getPublisherPluginDescriptor() {
            return (DropboxPublisherPlugin.Descriptor)Jenkins.get().getDescriptorByType(DropboxPublisherPlugin.Descriptor.class);
        }
    }
}

