/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.publishoverdropbox.impl;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.util.Secret;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.publishoverdropbox.DropboxToken;
import org.jenkinsci.plugins.publishoverdropbox.domain.DropboxV2;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.RestException;
import org.jenkinsci.plugins.publishoverdropbox.impl.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class DropboxTokenImpl
extends BaseStandardCredentials
implements DropboxToken {
    static final long serialVersionUID = 43L;
    @Nonnull
    private final Secret authorizationCode;
    @Nonnull
    private final Secret accessCode;

    @DataBoundConstructor
    public DropboxTokenImpl(CredentialsScope scope, String id, @Nonnull Secret authorizationCode, String description) throws IOException {
        super(scope, id, description);
        this.authorizationCode = authorizationCode;
        try {
            this.accessCode = DropboxV2.convertAuthorizationToAccessCode(authorizationCode);
        }
        catch (RestException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    @Nonnull
    public Secret getAuthorizationCode() {
        return this.authorizationCode;
    }

    @Override
    @Nonnull
    public Secret getAccessCode() {
        return this.accessCode;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return Messages.DropboxTokenImpl_api_token();
        }
    }
}

