/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.publishoverdropbox.impl;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.model.Describable;
import hudson.model.ItemGroup;
import hudson.util.Secret;
import java.io.IOException;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPClient;
import jenkins.plugins.publish_over.BPHostConfiguration;
import jenkins.plugins.publish_over.BapPublisherException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jenkinsci.plugins.publishoverdropbox.DropboxToken;
import org.jenkinsci.plugins.publishoverdropbox.descriptor.DropboxHostConfigurationDescriptor;
import org.jenkinsci.plugins.publishoverdropbox.domain.DropboxClient;
import org.jenkinsci.plugins.publishoverdropbox.domain.DropboxV2;
import org.jenkinsci.plugins.publishoverdropbox.impl.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class DropboxHostConfiguration
extends BPHostConfiguration<DropboxClient, Object>
implements Describable<DropboxHostConfiguration> {
    public static final int DEFAULT_TIMEOUT = 300000;
    private static final long serialVersionUID = 1L;
    private DropboxToken token;
    private final int timeout;

    @DataBoundConstructor
    public DropboxHostConfiguration(String name, String token, String remoteRootDir, int timeout) {
        super(name, null, null, null, remoteRootDir, 0);
        this.timeout = timeout;
        this.token = token == null ? null : this.lookupTokenId(token);
    }

    private DropboxToken lookupTokenId(String tokenId) {
        List credentials = CredentialsProvider.lookupCredentials(DropboxToken.class, (ItemGroup)Jenkins.getActiveInstance(), null, (DomainRequirement[])new DomainRequirement[]{null});
        for (DropboxToken token : credentials) {
            if (!tokenId.equals(token.getId())) continue;
            return token;
        }
        return null;
    }

    public DropboxToken getToken() {
        return this.token;
    }

    public void setToken(DropboxToken token) {
        this.token = token;
    }

    public DropboxClient createClient(BPBuildInfo buildInfo) {
        DropboxClient client = new DropboxClient(this.createDropbox(), buildInfo);
        try {
            this.init(client);
        }
        catch (IOException ioe) {
            throw new BapPublisherException(Messages.exception_bap_createclient(ioe.getLocalizedMessage()), (Throwable)ioe);
        }
        return client;
    }

    private DropboxV2 createDropbox() {
        if (this.token == null) {
            throw new BapPublisherException(Messages.exception_bap_createclient("Missing token"));
        }
        return new DropboxV2(Secret.toString((Secret)this.token.getAccessCode()));
    }

    private void init(DropboxClient client) throws IOException {
        this.configureDropboxclient(client);
        this.connect(client);
        this.changeToRootDirectory((BPClient)client);
        this.setRootDirectoryInClient(client);
    }

    private void configureDropboxclient(DropboxClient client) {
        client.setTimeout(this.timeout);
        client.setToken(Secret.toString((Secret)this.token.getAuthorizationCode()));
    }

    private void connect(DropboxClient client) {
        if (!client.connect()) {
            this.exception((BPClient)client, Messages.exception_bap_logInFailed(this.getToken()));
        }
    }

    private void setRootDirectoryInClient(DropboxClient client) {
        if (this.isDirectoryAbsolute(this.getRemoteRootDir())) {
            client.setAbsoluteRemoteRoot(this.getRemoteRootDir());
        }
    }

    public DropboxHostConfigurationDescriptor getDescriptor() {
        return (DropboxHostConfigurationDescriptor)Jenkins.getActiveInstance().getDescriptorByType(DropboxHostConfigurationDescriptor.class);
    }

    protected HashCodeBuilder addToHashCode(HashCodeBuilder builder) {
        return super.addToHashCode(builder).append((Object)this.token).append(this.timeout);
    }

    protected EqualsBuilder addToEquals(EqualsBuilder builder, DropboxHostConfiguration that) {
        return super.addToEquals(builder, (BPHostConfiguration)that).append((Object)this.token, (Object)that.token).append(this.timeout, that.timeout);
    }

    protected ToStringBuilder addToToString(ToStringBuilder builder) {
        return super.addToToString(builder).append("token", (Object)this.token).append("timeout", this.timeout);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || ((Object)((Object)this)).getClass() != that.getClass()) {
            return false;
        }
        return this.addToEquals(new EqualsBuilder(), (DropboxHostConfiguration)((Object)that)).isEquals();
    }

    public int hashCode() {
        return this.addToHashCode(new HashCodeBuilder()).toHashCode();
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }
}

