/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.publishoverdropbox.domain;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;

class URLBuilder {
    String scheme = "";
    String host = "";
    String path = "";
    String query = "";

    public URLBuilder(String uri) throws URISyntaxException {
        URI parseUri = new URI(uri);
        this.scheme = parseUri.getScheme() == null ? "" : parseUri.getScheme();
        this.host = parseUri.getHost() == null ? "" : parseUri.getHost();
        this.path = parseUri.getPath() == null ? "" : parseUri.getPath();
        this.query = parseUri.getQuery() == null ? "" : parseUri.getQuery();
    }

    public URLBuilder appendQueryParameter(String key, String value) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(this.query);
        if (sb.length() > 0) {
            sb.append("&");
        }
        sb.append(URLEncoder.encode(key, "UTF-8"));
        sb.append("=");
        sb.append(URLEncoder.encode(value, "UTF-8"));
        this.query = sb.toString();
        return this;
    }

    public URLBuilder appendPath(String str) {
        StringBuilder sb = new StringBuilder(this.path);
        if (sb.charAt(sb.length() - 1) != '/' && !str.startsWith("/")) {
            sb.append('/');
        }
        sb.append(str);
        this.path = sb.toString();
        return this;
    }

    public URL build() throws MalformedURLException {
        StringBuilder sb = new StringBuilder(this.path);
        if (this.query.length() > 0) {
            sb.append("?");
            sb.append(this.query);
        }
        return new URL(this.scheme, this.host, sb.toString());
    }
}

