/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.publishoverdropbox.domain;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import hudson.ProxyConfiguration;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.publishoverdropbox.impl.Messages;

class JsonObjectRequest<T> {
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String UTF_8 = "UTF-8";
    private static final String OCTET_STREAM = "application/octet-stream";
    private static final String PARAM_AUTHORIZATION = "Authorization";
    private static final String VALUE_BEARER = "Bearer ";
    private static final int TIMEOUT_30_SECONDS = 30000;
    private URL url;
    private InputStream bodyStream;
    private String contentType;
    private Gson gson;
    private Class<T> classOfT;
    private String bearerToken;
    private int timeout = 30000;
    private Map<String, String> headers = new HashMap<String, String>();
    private Class classOfError;
    private Method method = Method.GET;

    private JsonObjectRequest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T execute() throws IOException {
        T model = null;
        InputStream inputStream = null;
        InputStream errorStream = null;
        try {
            HttpURLConnection connection = this.openConnection(this.url);
            connection.setReadTimeout(this.timeout);
            connection.setConnectTimeout(this.timeout);
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                String asciiKey = JsonObjectRequest.httpHeaderEncode(entry.getKey());
                String asciiHeader = JsonObjectRequest.httpHeaderEncode(entry.getValue());
                connection.addRequestProperty(asciiKey, asciiHeader);
            }
            if (this.bearerToken != null) {
                this.signWithBearerToken(connection);
            }
            connection.setRequestMethod(this.method.name());
            connection.setDoOutput(false);
            boolean responseBody = this.method == Method.GET || this.method == Method.POST;
            connection.setDoInput(responseBody);
            if (this.bodyStream != null) {
                connection.setDoOutput(true);
                this.upload(connection);
            }
            int responseCode = connection.getResponseCode();
            String responseMessage = connection.getResponseMessage();
            if (responseCode < 200 || responseCode > 299) {
                String errorResponse;
                errorStream = connection.getErrorStream();
                if (this.classOfError != null) {
                    errorResponse = IOUtils.toString((InputStream)errorStream);
                    try {
                        errorResponse = JsonObjectRequest.readModel(this.gson, errorResponse, this.classOfError);
                    }
                    catch (JsonSyntaxException jsonSyntaxException) {}
                } else {
                    errorResponse = IOUtils.toString((InputStream)errorStream);
                }
                throw new IOException(errorResponse.toString(), new IOException(Messages.exception_http(responseCode, responseMessage)));
            }
            if (responseBody) {
                inputStream = connection.getInputStream();
                model = JsonObjectRequest.readModel(this.gson, inputStream, this.classOfT);
            }
        }
        catch (Throwable throwable) {
            JsonObjectRequest.closeQuietly(errorStream);
            JsonObjectRequest.closeQuietly(inputStream);
            throw throwable;
        }
        JsonObjectRequest.closeQuietly(errorStream);
        JsonObjectRequest.closeQuietly(inputStream);
        return model;
    }

    private HttpURLConnection openConnection(URL url) throws IOException {
        return (HttpURLConnection)ProxyConfiguration.open((URL)url);
    }

    public static String httpHeaderEncode(String text) {
        StringBuilder sb = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char charAt = text.charAt(i);
            if (charAt >= '\u007f') {
                sb.append(String.format("\\u%04X", charAt));
                continue;
            }
            sb.append(charAt);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(HttpURLConnection connection) throws IOException {
        if (this.contentType != null) {
            connection.addRequestProperty(HEADER_CONTENT_TYPE, this.contentType);
        } else {
            connection.addRequestProperty(HEADER_CONTENT_TYPE, OCTET_STREAM);
        }
        DataOutputStream outputStream = null;
        try {
            OutputStream stream = connection.getOutputStream();
            outputStream = new DataOutputStream(stream);
            IOUtils.copyLarge((InputStream)this.bodyStream, (OutputStream)outputStream);
            outputStream.flush();
        }
        catch (Throwable throwable) {
            JsonObjectRequest.closeQuietly(this.bodyStream);
            JsonObjectRequest.closeQuietly(outputStream);
            throw throwable;
        }
        JsonObjectRequest.closeQuietly(this.bodyStream);
        JsonObjectRequest.closeQuietly(outputStream);
    }

    private void signWithBearerToken(HttpURLConnection connection) {
        connection.setRequestProperty(PARAM_AUTHORIZATION, VALUE_BEARER + this.bearerToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <MODEL> MODEL readModel(Gson gson, InputStream inputStream, Class<MODEL> classOfModel) throws IOException {
        Object model = null;
        if (inputStream != null && classOfModel != null) {
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader((InputStream)new BufferedInputStream(inputStream, 4096), UTF_8);
                model = gson.fromJson((Reader)reader, classOfModel);
            }
            catch (Throwable throwable) {
                JsonObjectRequest.closeQuietly(reader);
                throw throwable;
            }
            JsonObjectRequest.closeQuietly(reader);
        }
        return (MODEL)model;
    }

    private static <MODEL> MODEL readModel(Gson gson, String jsonData, Class<MODEL> classOfModel) {
        Object model = null;
        if (jsonData != null) {
            model = gson.fromJson(jsonData, classOfModel);
        }
        return (MODEL)model;
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static enum Method {
        POST,
        GET,
        PUT,
        DELETE;

    }

    static class Builder<T> {
        JsonObjectRequest<T> request = new JsonObjectRequest();

        public Builder<T> url(URL url) {
            this.request.url = url;
            return this;
        }

        public Builder<T> gson(Gson gson) {
            this.request.gson = gson;
            return this;
        }

        public Builder<T> responseClass(Class<T> classOfT) {
            this.request.classOfT = classOfT;
            return this;
        }

        public Builder<T> responseErrorClass(Class classOfError) {
            this.request.classOfError = classOfError;
            return this;
        }

        public Builder<T> upload(InputStream content, String contentType) {
            this.request.contentType = contentType;
            this.request.bodyStream = content;
            return this;
        }

        public Builder<T> upload(String content, String contentType) {
            this.request.contentType = contentType;
            try {
                this.request.bodyStream = new ByteArrayInputStream(content.getBytes(JsonObjectRequest.UTF_8));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return this;
        }

        public Builder<T> addHeader(@Nonnull String key, @Nonnull String value) {
            this.request.headers.put(key, value);
            return this;
        }

        public Builder<T> method(Method method) {
            this.request.method = method;
            return this;
        }

        public Builder<T> sign(String accessCode) {
            this.request.bearerToken = accessCode;
            return this;
        }

        public Builder<T> timeout(int timeout) {
            this.request.timeout = timeout > 1000 ? timeout : 30000;
            return this;
        }

        public JsonObjectRequest<T> build() {
            return this.request;
        }
    }
}

