/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.publishoverdropbox.domain;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;

public class FormBuilder {
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String AND = "&";
    private static final String UTF_8 = "UTF-8";
    private static final String EQUALS = "=";
    private List<String> parameters = new LinkedList<String>();

    public FormBuilder appendQueryParameter(String key, String value) {
        this.parameters.add(key);
        this.parameters.add(value);
        return this;
    }

    public String build() throws UnsupportedEncodingException {
        StringBuilder query = new StringBuilder();
        for (int i = 0; i < this.parameters.size(); i += 2) {
            this.append(query, this.parameters.get(i), this.parameters.get(i + 1));
        }
        return query.toString();
    }

    private void append(StringBuilder query, String key, String value) throws UnsupportedEncodingException {
        if (query.length() > 0) {
            query.append(AND);
        }
        query.append(URLEncoder.encode(key, UTF_8));
        query.append(EQUALS);
        query.append(URLEncoder.encode(value, UTF_8));
    }
}

