/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.publishoverdropbox.domain;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import hudson.model.ItemGroup;
import hudson.util.Secret;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.publishoverdropbox.DropboxToken;
import org.jenkinsci.plugins.publishoverdropbox.domain.ChunkedInputStream;
import org.jenkinsci.plugins.publishoverdropbox.domain.DropboxAdapter;
import org.jenkinsci.plugins.publishoverdropbox.domain.FormBuilder;
import org.jenkinsci.plugins.publishoverdropbox.domain.JsonObjectRequest;
import org.jenkinsci.plugins.publishoverdropbox.domain.URLBuilder;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.AccountInfo;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.ErrorResponse;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.FileMetadata;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.FolderContent;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.FolderMetadata;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.Metadata;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.RestException;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.Session;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.TokenResponse;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.requests.CreateFolderRequest;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.requests.CursorRequest;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.requests.DeleteRequest;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.requests.ListFolderRequest;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.requests.MetadataRequest;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.requests.SessionAppend;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.requests.SessionFinish;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.requests.SessionStart;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.requests.UploadRequest;
import org.jenkinsci.plugins.publishoverdropbox.gson.RuntimeTypeAdapterFactory;
import org.jenkinsci.plugins.publishoverdropbox.impl.Messages;

public class DropboxV2
implements DropboxAdapter {
    private static final String URL_TOKEN = "https://api.dropbox.com/oauth2/token";
    private static final String URL_ACCOUNT_INFO = "https://api.dropbox.com/2/users/get_current_account";
    private static final String URL_METADATA = "https://api.dropboxapi.com/2/files/get_metadata";
    private static final String URL_LIST_FOLDER = "https://api.dropboxapi.com/2/files/list_folder";
    private static final String URL_LIST_FOLDER_CONTINUE = "https://api.dropboxapi.com/2/files/list_folder/continue";
    private static final String URL_OPS_DELETE = "https://api.dropboxapi.com/2/files/delete";
    private static final String URL_CREATE_FOLDER = "https://api.dropboxapi.com/2/files/create_folder";
    private static final String URL_UPLOAD = "https://content.dropboxapi.com/2/files/upload";
    private static final String URL_UPLOAD_START = "https://content.dropboxapi.com/2/files/upload_session/start";
    private static final String URL_UPLOAD_APPEND = "https://content.dropboxapi.com/2/files/upload_session/append_v2";
    private static final String URL_UPLOAD_FINISH = "https://content.dropboxapi.com/2/files/upload_session/finish";
    private static final String PATH_SEPARATOR = "/";
    private static final String VALUE_AUTHORIZATION_CODE = "authorization_code";
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    private static final long FOUR_MEGA_BYTE = 0x400000L;
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    @VisibleForTesting
    long chunkSize = 0x400000L;
    private int timeout = -1;
    private final String accessToken;
    private final Gson gson;
    private AccountInfo userInfo;
    private FolderMetadata workingFolder;

    public DropboxV2(String accessToken) {
        this.accessToken = accessToken;
        this.gson = DropboxV2.createGson();
    }

    public static Gson createGson() {
        RuntimeTypeAdapterFactory<FileMetadata> metadataAdapterFactory = RuntimeTypeAdapterFactory.of(Metadata.class, ".tag").registerSubtype(FolderMetadata.class, "folder").registerSubtype(FileMetadata.class, "file");
        return new GsonBuilder().registerTypeAdapterFactory(metadataAdapterFactory).create();
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout >= 1000 ? timeout : -1;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public boolean connect() throws RestException {
        this.userInfo = this.retrieveAccountInfo();
        return this.isConnected();
    }

    @Override
    public boolean isConnected() {
        return !StringUtils.isEmpty((String)this.accessToken) && this.userInfo != null && !this.userInfo.isDisabled();
    }

    @Override
    public boolean disconnect() {
        this.userInfo = null;
        return true;
    }

    private AccountInfo retrieveAccountInfo() throws RestException {
        URL url = DropboxV2.getUrl(URL_ACCOUNT_INFO);
        JsonObjectRequest<AccountInfo> request = this.requestForPostUrlClassResponse(url, AccountInfo.class);
        try {
            return request.execute();
        }
        catch (IOException e) {
            throw new RestException(Messages.exception_rest_connection(), e);
        }
    }

    @Override
    public boolean changeWorkingDirectory(@Nonnull String relativePath) throws RestException {
        boolean hasSuccess = true;
        try {
            Metadata metadata;
            if (!StringUtils.isEmpty((String)relativePath) && (metadata = this.retrieveMetaData(relativePath)).isDir() && metadata instanceof FolderMetadata) {
                this.workingFolder = (FolderMetadata)metadata;
            }
        }
        catch (RestException e) {
            hasSuccess = false;
        }
        return hasSuccess && this.workingFolder != null && this.workingFolder.isDir();
    }

    @Override
    public FolderMetadata makeDirectory(@Nonnull String path) throws RestException {
        URL url = DropboxV2.getUrl(URL_CREATE_FOLDER);
        FolderMetadata folder = null;
        String absolute = this.createAbsolutePath(path);
        try {
            Metadata metadata = this.retrieveMetaData(absolute);
            if (metadata.isDir()) {
                folder = (FolderMetadata)metadata;
            }
        }
        catch (RestException re) {
            folder = null;
        }
        if (folder == null) {
            CreateFolderRequest requestContent = new CreateFolderRequest();
            requestContent.setPath(absolute);
            JsonObjectRequest<FolderMetadata> request = this.requestPostRequestResponse(url, requestContent, FolderMetadata.class);
            try {
                folder = request.execute();
            }
            catch (IOException e) {
                throw new RestException(Messages.exception_dropbox_folder_create(path), e);
            }
        }
        return folder;
    }

    @Override
    public void cleanWorkingFolder() throws RestException {
        if (this.workingFolder.isDir()) {
            FolderContent contents = this.listFilesOfFolder(this.workingFolder);
            String cursor = null;
            do {
                if (cursor != null) {
                    contents = this.listFilesForCursor(cursor);
                }
                for (Metadata entry : contents.getEntries()) {
                    this.delete(entry);
                }
                if (!contents.hasMore()) continue;
                cursor = contents.getCursor();
            } while (contents.hasMore() && cursor != null);
        } else {
            throw new RestException(Messages.exception_dropbox_folder_delete(this.workingFolder.getName()));
        }
    }

    void delete(@Nonnull Metadata metadata) throws RestException {
        String path = metadata.getPathLower();
        this.delete(path);
    }

    void delete(@Nonnull String path) throws RestException {
        URL url = DropboxV2.getUrl(URL_OPS_DELETE);
        DeleteRequest requestContent = new DeleteRequest();
        String absolute = this.createAbsolutePath(path);
        requestContent.setPath(absolute);
        if (StringUtils.isNotEmpty((String)path) && !PATH_SEPARATOR.equals(path)) {
            JsonObjectRequest<Metadata> request = this.requestPostRequestResponse(url, requestContent, Metadata.class);
            try {
                request.execute();
            }
            catch (IOException e) {
                throw new RestException(Messages.exception_dropbox_folder_delete(path), e);
            }
        } else {
            throw new RestException(Messages.exception_dropbox_folder_delete(path));
        }
    }

    @Override
    public void pruneFolder(@Nonnull String path, int pruneRootDays) throws RestException {
        Date cutoff = new Date(System.currentTimeMillis() - (long)pruneRootDays * 86400000L);
        String absolute = this.createAbsolutePath(path);
        FolderContent contents = this.listFilesOfPath(absolute);
        String cursor = null;
        do {
            if (cursor != null) {
                contents = this.listFilesForCursor(cursor);
            }
            for (Metadata entry : contents.getEntries()) {
                boolean isModifiedSince = this.isEntryModifiedSince(entry, cutoff);
                if (isModifiedSince) continue;
                this.delete(entry.getPathLower());
            }
            cursor = contents.getCursor();
        } while (contents.hasMore() && cursor != null);
    }

    private boolean isEntryModifiedSince(@Nonnull Metadata metadata, @Nonnull Date cutoff) throws RestException {
        boolean isModifiedSince = false;
        if (metadata instanceof FileMetadata) {
            Date lastModified = this.parseDate(((FileMetadata)metadata).getServerModified());
            isModifiedSince = lastModified.after(cutoff);
        } else if (metadata instanceof FolderMetadata) {
            FolderContent contents = this.listFilesOfFolder((FolderMetadata)metadata);
            String cursor = null;
            block0: do {
                if (cursor != null) {
                    contents = this.listFilesForCursor(cursor);
                }
                List<Metadata> entries = contents.getEntries();
                for (Metadata entry : entries) {
                    if (!(entry instanceof FileMetadata) || !(isModifiedSince = this.isEntryModifiedSince(entry, cutoff))) continue;
                    break block0;
                }
                for (Metadata entry : entries) {
                    if (!(entry instanceof FolderMetadata) || !(isModifiedSince = this.isEntryModifiedSince(entry, cutoff))) continue;
                    break block0;
                }
                cursor = contents.getCursor();
            } while (contents.hasMore() && cursor != null);
        }
        return isModifiedSince;
    }

    @VisibleForTesting
    Date parseDate(String serverModified) throws RestException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        try {
            return df.parse(serverModified);
        }
        catch (ParseException e) {
            throw new RestException(Messages.exception_dropbox_folder_prunedate(serverModified), e);
        }
    }

    @Override
    public void storeFile(@Nonnull String name, @Nonnull InputStream content, long length) throws RestException {
        if (length <= this.chunkSize) {
            this.singleStore(name, content, length);
        } else {
            this.chunkedStore(name, content, length);
        }
    }

    private FileMetadata singleStore(@Nonnull String name, @Nonnull InputStream content, long length) throws RestException {
        FileMetadata fileMetadata;
        URL url = DropboxV2.getUrl(URL_UPLOAD);
        UploadRequest uploadRequest = new UploadRequest();
        uploadRequest.setPath(this.createPath(name));
        JsonObjectRequest<FileMetadata> request = this.requestForUpload(url, uploadRequest, FileMetadata.class, content, length);
        try {
            fileMetadata = request.execute();
        }
        catch (IOException e) {
            throw new RestException(Messages.exception_dropbox_file_upload_simple(name), e);
        }
        return fileMetadata;
    }

    private void chunkedStore(String name, InputStream content, long length) throws RestException {
        Session session;
        long offSet = 0L;
        URL startUrl = DropboxV2.getUrl(URL_UPLOAD_START);
        ChunkedInputStream chunkStream = new ChunkedInputStream(content, this.chunkSize);
        SessionStart startContent = new SessionStart();
        JsonObjectRequest<Session> startRequest = this.requestForUpload(startUrl, startContent, Session.class, chunkStream, this.chunkSize);
        try {
            session = startRequest.execute();
        }
        catch (IOException e) {
            throw new RestException(Messages.exception_store_chunk_end(name), e);
        }
        offSet += this.chunkSize;
        while (length - offSet > this.chunkSize) {
            URL appendUrl = DropboxV2.getUrl(URL_UPLOAD_APPEND);
            chunkStream = new ChunkedInputStream(content, this.chunkSize);
            SessionAppend appendContent = new SessionAppend();
            appendContent.cursor.setOffset(offSet);
            appendContent.cursor.setSessionId(session.getSessionId());
            JsonObjectRequest<ErrorResponse> appendRequest = this.requestForUpload(appendUrl, appendContent, ErrorResponse.class, chunkStream, this.chunkSize);
            try {
                appendRequest.execute();
            }
            catch (IOException e) {
                throw new RestException(Messages.exception_store_chunk_continue(name), e);
            }
            offSet += this.chunkSize;
        }
        URL finishUrl = DropboxV2.getUrl(URL_UPLOAD_FINISH);
        chunkStream = new ChunkedInputStream(content, this.chunkSize);
        SessionFinish finishContent = new SessionFinish();
        finishContent.cursor.setSessionId(session.getSessionId());
        finishContent.cursor.setOffset(offSet);
        finishContent.commit.setPath(this.createPath(name));
        JsonObjectRequest<FileMetadata> finishRequest = this.requestForUpload(finishUrl, finishContent, FileMetadata.class, chunkStream, length - offSet);
        try {
            finishRequest.execute();
        }
        catch (IOException e) {
            throw new RestException(Messages.exception_store_chunk_end(name), e);
        }
    }

    @VisibleForTesting
    FolderContent listFilesOfFolder(@Nonnull FolderMetadata folder) throws RestException {
        return this.listFilesOfPath(folder.getPathLower());
    }

    private FolderContent listFilesOfPath(@Nonnull String path) throws RestException {
        FolderContent content;
        URL url = DropboxV2.getUrl(URL_LIST_FOLDER);
        ListFolderRequest requestContent = new ListFolderRequest();
        requestContent.setPath(path);
        JsonObjectRequest<FolderContent> request = this.requestPostRequestResponse(url, requestContent, FolderContent.class);
        try {
            content = request.execute();
        }
        catch (IOException e) {
            throw new RestException(Messages.exception_dropbox_folder_list(path), e);
        }
        return content;
    }

    private FolderContent listFilesForCursor(String cursor) throws RestException {
        FolderContent content;
        URL url = DropboxV2.getUrl(URL_LIST_FOLDER_CONTINUE);
        CursorRequest requestContent = new CursorRequest();
        requestContent.setCursor(cursor);
        JsonObjectRequest<FolderContent> request = this.requestPostRequestResponse(url, requestContent, FolderContent.class);
        try {
            content = request.execute();
        }
        catch (IOException e) {
            throw new RestException(Messages.exception_dropbox_folder_list_cursor(), e);
        }
        return content;
    }

    @VisibleForTesting
    Metadata retrieveMetaData(String relative) throws RestException {
        Metadata metadata;
        URL url = DropboxV2.getUrl(URL_METADATA);
        MetadataRequest requestContent = new MetadataRequest();
        String absolute = this.createAbsolutePath(relative);
        requestContent.setPath(absolute);
        JsonObjectRequest<Metadata> request = this.requestPostRequestResponse(url, requestContent, Metadata.class);
        try {
            metadata = request.execute();
        }
        catch (IOException e) {
            throw new RestException(Messages.exception_dropbox_file_metadata(relative), e);
        }
        return metadata;
    }

    private <T> JsonObjectRequest<T> requestForPostUrlClassResponse(URL url, Class<T> classOfT) {
        JsonObjectRequest.Builder builder = new JsonObjectRequest.Builder();
        builder.url(url).gson(this.gson).method(JsonObjectRequest.Method.POST).responseClass(classOfT).responseErrorClass(ErrorResponse.class).sign(this.accessToken).timeout(this.timeout);
        return builder.build();
    }

    private <T> JsonObjectRequest<T> requestPostRequestResponse(URL url, Object requestContent, Class<T> classOfT) {
        String content = this.gson.toJson(requestContent);
        JsonObjectRequest.Builder builder = new JsonObjectRequest.Builder();
        builder.url(url).gson(this.gson).method(JsonObjectRequest.Method.POST).upload(content, APPLICATION_JSON).responseClass(classOfT).responseErrorClass(ErrorResponse.class).sign(this.accessToken).timeout(this.timeout);
        return builder.build();
    }

    private <T> JsonObjectRequest<T> requestForUpload(URL url, Object requestContent, Class<T> responseClass, @Nonnull InputStream content, long length) {
        JsonObjectRequest.Builder builder = new JsonObjectRequest.Builder().url(url).gson(this.gson).method(JsonObjectRequest.Method.POST).upload(content, APPLICATION_OCTET_STREAM).addHeader("Dropbox-API-Arg", this.gson.toJson(requestContent)).addHeader("Content-Length", Long.toString(length)).responseClass(responseClass).responseErrorClass(ErrorResponse.class).sign(this.accessToken).timeout(this.timeout);
        return builder.build();
    }

    private static URL getUrl(String urlSource) throws RestException {
        URL url;
        try {
            url = new URLBuilder(urlSource).build();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RestException(Messages.exception_dropbox_url(), e);
        }
        return url;
    }

    private String createAbsolutePath(String path) {
        StringBuilder sb = new StringBuilder();
        if (path.startsWith(PATH_SEPARATOR)) {
            sb.append(path);
        } else {
            if (this.workingFolder != null) {
                sb.append(this.workingFolder.getPathLower());
            }
            if (sb.length() == 0 || !PATH_SEPARATOR.equals(sb.substring(sb.length() - 1))) {
                sb.append(PATH_SEPARATOR);
            }
            sb.append(path);
        }
        return sb.toString();
    }

    private String createPath(String name) {
        String path = this.workingFolder.getPathLower().endsWith(PATH_SEPARATOR) ? this.workingFolder.getPathLower() + name : this.workingFolder.getPathLower() + PATH_SEPARATOR + name;
        return path;
    }

    public static Secret convertAuthorizationToAccessCode(Secret secretAuthorizationCode) throws RestException {
        String authorizationCode = Secret.toString((Secret)secretAuthorizationCode);
        if (StringUtils.isEmpty((String)authorizationCode)) {
            return Secret.fromString(null);
        }
        String accessToken = DropboxV2.readAccessTokenFromProvider(authorizationCode);
        if (accessToken == null) {
            accessToken = DropboxV2.readAccessTokenFromWeb(authorizationCode);
        }
        return Secret.fromString((String)accessToken);
    }

    private static String readAccessTokenFromWeb(String authorizationCode) throws RestException {
        TokenResponse response;
        URL url = DropboxV2.getUrl(URL_TOKEN);
        FormBuilder formBuilder = new FormBuilder().appendQueryParameter("code", authorizationCode).appendQueryParameter("grant_type", VALUE_AUTHORIZATION_CODE).appendQueryParameter("client_id", "noej9fhmqtnhje4");
        try {
            Class<?> privateConfig = Class.forName("org.jenkinsci.plugins.publishoverdropbox.domain.C");
            Class[] argClass = new Class[]{formBuilder.getClass()};
            Method method = privateConfig.getDeclaredMethod("a", argClass);
            method.invoke(null, formBuilder);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            formBuilder.appendQueryParameter("client_secret", "your_app_secret");
        }
        try {
            JsonObjectRequest<TokenResponse> request = new JsonObjectRequest.Builder().gson(new Gson()).responseClass(TokenResponse.class).url(url).upload(formBuilder.build(), "application/x-www-form-urlencoded").responseErrorClass(ErrorResponse.class).build();
            response = request.execute();
        }
        catch (IOException e) {
            throw new RestException(Messages.exception_accesstokens(), e);
        }
        String accessToken = response.getAccessToken();
        return accessToken;
    }

    private static String readAccessTokenFromProvider(String authorizationCode) {
        String accessToken = null;
        List tokens = CredentialsProvider.lookupCredentials(DropboxToken.class, (ItemGroup)Jenkins.getInstance(), null, (DomainRequirement[])new DomainRequirement[]{null});
        for (DropboxToken token : tokens) {
            String providerAuthorizationCode = Secret.toString((Secret)token.getAuthorizationCode());
            if (!providerAuthorizationCode.equals(authorizationCode)) continue;
            accessToken = Secret.toString((Secret)token.getAccessCode());
        }
        return accessToken;
    }

    Metadata getWorkingFolder() {
        return this.workingFolder;
    }
}

