/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.publishoverdropbox.domain;

import hudson.FilePath;
import java.io.IOException;
import java.io.InputStream;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPDefaultClient;
import jenkins.plugins.publish_over.BapPublisherException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.plugins.publishoverdropbox.domain.DropboxAdapter;
import org.jenkinsci.plugins.publishoverdropbox.domain.DropboxV2;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.FolderMetadata;
import org.jenkinsci.plugins.publishoverdropbox.domain.model.RestException;
import org.jenkinsci.plugins.publishoverdropbox.impl.DropboxTransfer;
import org.jenkinsci.plugins.publishoverdropbox.impl.Messages;

public class DropboxClient
extends BPDefaultClient<DropboxTransfer> {
    private static final Log LOG = LogFactory.getLog(DropboxClient.class);
    private BPBuildInfo buildInfo;
    private final DropboxAdapter dropbox;
    private String token;

    public DropboxClient(DropboxV2 client, BPBuildInfo buildInfo) {
        this.dropbox = client;
        this.buildInfo = buildInfo;
    }

    public BPBuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public void setBuildInfo(BPBuildInfo buildInfo) {
        this.buildInfo = buildInfo;
    }

    public boolean changeDirectory(String directory) {
        try {
            return this.dropbox.changeWorkingDirectory(directory);
        }
        catch (RestException e) {
            throw new BapPublisherException(Messages.exception_bap_changeDirectory(e.getMessage()), (Throwable)e);
        }
    }

    public boolean makeDirectory(String path) {
        try {
            FolderMetadata folder = this.dropbox.makeDirectory(path);
            return folder != null;
        }
        catch (RestException e) {
            throw new BapPublisherException(Messages.exception_bap_makeDirectory(e.getMessage()), (Throwable)e);
        }
    }

    public void deleteTree() {
        try {
            this.dropbox.cleanWorkingFolder();
        }
        catch (RestException e) {
            throw new BapPublisherException(Messages.exception_bap_deleteTree(e.getMessage()), (Throwable)e);
        }
    }

    public void beginTransfers(DropboxTransfer transfer) {
        if (!transfer.hasConfiguredSourceFiles()) {
            throw new BapPublisherException(Messages.exception_noSourceFiles());
        }
        if (transfer.isRemoteDirectorySDF() && transfer.isPruneRoot()) {
            try {
                this.dropbox.pruneFolder(this.getAbsoluteRemoteRoot(), transfer.getPruneRootDays());
            }
            catch (RestException e) {
                throw new BapPublisherException(Messages.exception_bap_pruneFolder(e.getMessage()), (Throwable)e);
            }
        }
    }

    public void transferFile(DropboxTransfer transfer, FilePath filePath, InputStream content) {
        try {
            this.dropbox.storeFile(filePath.getName(), content, filePath.length());
        }
        catch (RestException e) {
            throw new BapPublisherException(Messages.exception_bap_transferFile(e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            throw new BapPublisherException(Messages.exception_bap_transferFile(e.getMessage()), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new BapPublisherException(Messages.exception_bap_transferFile(e.getMessage()), (Throwable)e);
        }
    }

    public boolean connect() {
        try {
            return this.dropbox.isConnected() || this.dropbox.connect();
        }
        catch (RestException e) {
            throw new BapPublisherException(Messages.exception_bap_connect(e.getMessage()), (Throwable)e);
        }
    }

    public void disconnect() {
        if (this.dropbox != null && this.dropbox.isConnected()) {
            this.dropbox.disconnect();
        }
    }

    public void disconnectQuietly() {
        this.disconnect();
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public void setTimeout(int timeout) {
        this.dropbox.setTimeout(timeout);
    }

    public int getTimeout() {
        return this.dropbox.getTimeout();
    }
}

