/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.publishoverdropbox.domain;

import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private final InputStream source;
    private final long chunkSize;
    private long progress;

    public ChunkedInputStream(InputStream source, long chunkSize) {
        this.source = source;
        this.chunkSize = chunkSize;
        this.progress = 0L;
    }

    @Override
    public int read() throws IOException {
        int read = -1;
        if (this.progress < this.chunkSize) {
            ++this.progress;
            read = this.source.read();
        }
        return read;
    }

    @Override
    public int available() throws IOException {
        int limitTo = (int)(this.chunkSize - this.progress);
        return Math.min(limitTo, super.available());
    }
}

