/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.publishoverdropbox.descriptor;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import hudson.util.VersionNumber;
import java.util.Collection;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.JenkinsCapabilities;
import jenkins.plugins.publish_over.view_defaults.BPInstanceConfig.Messages;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.publishoverdropbox.descriptor.DropboxHostConfigurationDescriptor;
import org.jenkinsci.plugins.publishoverdropbox.descriptor.DropboxPublisherDescriptor;
import org.jenkinsci.plugins.publishoverdropbox.impl.DropboxHostConfiguration;
import org.jenkinsci.plugins.publishoverdropbox.impl.DropboxPublisherPlugin;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class DropboxPublisherPluginDescriptor
extends BuildStepDescriptor<Publisher> {
    private final CopyOnWriteList<DropboxHostConfiguration> hostConfigurations = new CopyOnWriteList();

    public DropboxPublisherPluginDescriptor() {
        super(DropboxPublisherPlugin.class);
        this.load();
    }

    public String getDisplayName() {
        return org.jenkinsci.plugins.publishoverdropbox.impl.Messages.descriptor_displayName();
    }

    public boolean isApplicable(Class<? extends AbstractProject> aClass) {
        return !"hudson.plugins.promoted_builds.PromotionProcess".equals(aClass.getCanonicalName());
    }

    public List<DropboxHostConfiguration> getHostConfigurations() {
        return this.hostConfigurations.getView();
    }

    public DropboxHostConfiguration getConfiguration(String name) {
        for (DropboxHostConfiguration configuration : this.hostConfigurations) {
            if (!configuration.getName().equals(name)) continue;
            return configuration;
        }
        return null;
    }

    public boolean configure(StaplerRequest request, JSONObject formData) {
        this.hostConfigurations.replaceBy((Collection)request.bindJSONToList(DropboxHostConfiguration.class, formData.get("instance")));
        this.save();
        return true;
    }

    public boolean canSetMasterNodeName() {
        return JenkinsCapabilities.missing((VersionNumber)JenkinsCapabilities.MASTER_HAS_NODE_NAME);
    }

    public String getDefaultMasterNodeName() {
        return "master";
    }

    public boolean isEnableOverrideDefaults() {
        return JenkinsCapabilities.available((VersionNumber)JenkinsCapabilities.SIMPLE_DESCRIPTOR_SELECTOR);
    }

    public DropboxPublisherDescriptor getPublisherDescriptor() {
        return (DropboxPublisherDescriptor)Jenkins.get().getDescriptorByType(DropboxPublisherDescriptor.class);
    }

    public DropboxHostConfigurationDescriptor getHostConfigurationDescriptor() {
        return (DropboxHostConfigurationDescriptor)Jenkins.get().getDescriptorByType(DropboxHostConfigurationDescriptor.class);
    }

    public Messages getCommonFieldNames() {
        return new Messages();
    }

    public jenkins.plugins.publish_over.view_defaults.manage_jenkins.Messages getCommonManageMessages() {
        return new jenkins.plugins.publish_over.view_defaults.manage_jenkins.Messages();
    }

    public FormValidation doTestConnection(StaplerRequest request, StaplerResponse response) {
        DropboxHostConfiguration hostConfig = (DropboxHostConfiguration)((Object)request.bindParameters(DropboxHostConfiguration.class, ""));
        BPBuildInfo buildInfo = this.createDummyBuildInfo();
        try {
            hostConfig.createClient(buildInfo).disconnect();
            return FormValidation.ok((String)org.jenkinsci.plugins.publishoverdropbox.impl.Messages.form_testConnection_ok());
        }
        catch (Exception e) {
            return FormValidation.errorWithMarkup((String)("<p>" + org.jenkinsci.plugins.publishoverdropbox.impl.Messages.form_testConnection_error() + "</p><p><pre>" + Util.escape((String)(e.getClass().getCanonicalName() + ": " + e.getLocalizedMessage())) + "</pre></p>"));
        }
    }

    private BPBuildInfo createDummyBuildInfo() {
        return new BPBuildInfo(TaskListener.NULL, "", Jenkins.get().getRootPath(), null, null);
    }

    public Object readResolve() {
        return this;
    }
}

