/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.publishoverdropbox.descriptor;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.publish_over.BPValidators;
import jenkins.plugins.publish_over.view_defaults.HostConfiguration.Messages;
import org.jenkinsci.plugins.publishoverdropbox.DropboxToken;
import org.jenkinsci.plugins.publishoverdropbox.impl.DropboxHostConfiguration;
import org.jenkinsci.plugins.publishoverdropbox.impl.DropboxPublisherPlugin;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class DropboxHostConfigurationDescriptor
extends Descriptor<DropboxHostConfiguration> {
    public DropboxHostConfigurationDescriptor() {
        super(DropboxHostConfiguration.class);
    }

    public String getDisplayName() {
        return org.jenkinsci.plugins.publishoverdropbox.impl.Messages.hostconfig_descriptor();
    }

    public int getDefaultTimeout() {
        return 300000;
    }

    public FormValidation doCheckName(@QueryParameter String value) {
        return BPValidators.validateName((String)value);
    }

    public FormValidation doCheckTimeout(@QueryParameter String value) {
        return FormValidation.validateNonNegativeInteger((String)value);
    }

    public FormValidation doCheckRemoteRootDir(@QueryParameter String remoteRootDir) {
        if (remoteRootDir.matches("/.*")) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)org.jenkinsci.plugins.publishoverdropbox.impl.Messages.hostconfig_formvalidation_root());
    }

    public ListBoxModel doFillTokenItems() {
        ListBoxModel items = new ListBoxModel();
        for (DropboxToken token : this.getDropboxTokens()) {
            items.add(token.getDescription(), token.getId());
        }
        if (items.size() > 0) {
            ((ListBoxModel.Option)items.get((int)0)).selected = true;
        }
        return items;
    }

    private List<DropboxToken> getDropboxTokens() {
        return CredentialsProvider.lookupCredentials(DropboxToken.class, (ItemGroup)Jenkins.get(), null, (DomainRequirement[])new DomainRequirement[]{null});
    }

    public FormValidation doTestConnection(StaplerRequest request, StaplerResponse response) {
        DropboxPublisherPlugin.Descriptor pluginDescriptor = (DropboxPublisherPlugin.Descriptor)Jenkins.get().getDescriptorByType(DropboxPublisherPlugin.Descriptor.class);
        return pluginDescriptor.doTestConnection(request, response);
    }

    public Messages getCommonFieldNames() {
        return new Messages();
    }
}

