// CHECKSTYLE:OFF

package org.jenkinsci.plugins.publishoverdropbox.impl;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code exception.dropbox.folder.delete}: {@code Failed to delete,
     * {0} does not contain a folder to clear}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to delete, {0} does not contain a folder to clear}
     */
    public static String exception_dropbox_folder_delete(Object arg0) {
        return holder.format("exception.dropbox.folder.delete", arg0);
    }

    /**
     * Key {@code exception.dropbox.folder.delete}: {@code Failed to delete,
     * {0} does not contain a folder to clear}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to delete, {0} does not contain a folder to clear}
     */
    public static Localizable _exception_dropbox_folder_delete(Object arg0) {
        return new Localizable(holder, "exception.dropbox.folder.delete", arg0);
    }

    /**
     * Key {@code exception_bap.makeDirectory}: {@code Make directory failed:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Make directory failed: {0}}
     */
    public static String exception_bap_makeDirectory(Object arg0) {
        return holder.format("exception_bap.makeDirectory", arg0);
    }

    /**
     * Key {@code exception_bap.makeDirectory}: {@code Make directory failed:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Make directory failed: {0}}
     */
    public static Localizable _exception_bap_makeDirectory(Object arg0) {
        return new Localizable(holder, "exception_bap.makeDirectory", arg0);
    }

    /**
     * Key {@code console.message.prefix}: {@code Dropbox:}.
     * 
     * @return
     *     {@code Dropbox:}
     */
    public static String console_message_prefix() {
        return holder.format("console.message.prefix");
    }

    /**
     * Key {@code console.message.prefix}: {@code Dropbox:}.
     * 
     * @return
     *     {@code Dropbox:}
     */
    public static Localizable _console_message_prefix() {
        return new Localizable(holder, "console.message.prefix");
    }

    /**
     * Key {@code exception.bap.connect}: {@code Connect failed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connect failed: {0}}
     */
    public static String exception_bap_connect(Object arg0) {
        return holder.format("exception.bap.connect", arg0);
    }

    /**
     * Key {@code exception.bap.connect}: {@code Connect failed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connect failed: {0}}
     */
    public static Localizable _exception_bap_connect(Object arg0) {
        return new Localizable(holder, "exception.bap.connect", arg0);
    }

    /**
     * Key {@code exception.bap.createclient}: {@code Failed to connect and
     * initialize Dropbox connection. Message: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to connect and initialize Dropbox connection. Message:
     *     {0}}
     */
    public static String exception_bap_createclient(Object arg0) {
        return holder.format("exception.bap.createclient", arg0);
    }

    /**
     * Key {@code exception.bap.createclient}: {@code Failed to connect and
     * initialize Dropbox connection. Message: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to connect and initialize Dropbox connection. Message:
     *     {0}}
     */
    public static Localizable _exception_bap_createclient(Object arg0) {
        return new Localizable(holder, "exception.bap.createclient", arg0);
    }

    /**
     * Key {@code descriptor.displayName}: {@code Send build artifacts over
     * Dropbox}.
     * 
     * @return
     *     {@code Send build artifacts over Dropbox}
     */
    public static String descriptor_displayName() {
        return holder.format("descriptor.displayName");
    }

    /**
     * Key {@code descriptor.displayName}: {@code Send build artifacts over
     * Dropbox}.
     * 
     * @return
     *     {@code Send build artifacts over Dropbox}
     */
    public static Localizable _descriptor_displayName() {
        return new Localizable(holder, "descriptor.displayName");
    }

    /**
     * Key {@code hostconfig.descriptor}: {@code Dropbox Account
     * Configuration}.
     * 
     * @return
     *     {@code Dropbox Account Configuration}
     */
    public static String hostconfig_descriptor() {
        return holder.format("hostconfig.descriptor");
    }

    /**
     * Key {@code hostconfig.descriptor}: {@code Dropbox Account
     * Configuration}.
     * 
     * @return
     *     {@code Dropbox Account Configuration}
     */
    public static Localizable _hostconfig_descriptor() {
        return new Localizable(holder, "hostconfig.descriptor");
    }

    /**
     * Key {@code form.testConnection.error}: {@code Failed to connect or
     * change directory}.
     * 
     * @return
     *     {@code Failed to connect or change directory}
     */
    public static String form_testConnection_error() {
        return holder.format("form.testConnection.error");
    }

    /**
     * Key {@code form.testConnection.error}: {@code Failed to connect or
     * change directory}.
     * 
     * @return
     *     {@code Failed to connect or change directory}
     */
    public static Localizable _form_testConnection_error() {
        return new Localizable(holder, "form.testConnection.error");
    }

    /**
     * Key {@code exception_bap.pruneFolder}: {@code Pruning failed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Pruning failed: {0}}
     */
    public static String exception_bap_pruneFolder(Object arg0) {
        return holder.format("exception_bap.pruneFolder", arg0);
    }

    /**
     * Key {@code exception_bap.pruneFolder}: {@code Pruning failed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Pruning failed: {0}}
     */
    public static Localizable _exception_bap_pruneFolder(Object arg0) {
        return new Localizable(holder, "exception_bap.pruneFolder", arg0);
    }

    /**
     * Key {@code exception.dropbox.folder.list.cursor}: {@code Failed to
     * list more of folder content}.
     * 
     * @return
     *     {@code Failed to list more of folder content}
     */
    public static String exception_dropbox_folder_list_cursor() {
        return holder.format("exception.dropbox.folder.list.cursor");
    }

    /**
     * Key {@code exception.dropbox.folder.list.cursor}: {@code Failed to
     * list more of folder content}.
     * 
     * @return
     *     {@code Failed to list more of folder content}
     */
    public static Localizable _exception_dropbox_folder_list_cursor() {
        return new Localizable(holder, "exception.dropbox.folder.list.cursor");
    }

    /**
     * Key {@code exception.transferFile}: {@code Could not write file.
     * Server message: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not write file. Server message: {0}}
     */
    public static String exception_transferFile(Object arg0) {
        return holder.format("exception.transferFile", arg0);
    }

    /**
     * Key {@code exception.transferFile}: {@code Could not write file.
     * Server message: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not write file. Server message: {0}}
     */
    public static Localizable _exception_transferFile(Object arg0) {
        return new Localizable(holder, "exception.transferFile", arg0);
    }

    /**
     * Key {@code publisher.descriptor}: {@code Dropbox Publisher}.
     * 
     * @return
     *     {@code Dropbox Publisher}
     */
    public static String publisher_descriptor() {
        return holder.format("publisher.descriptor");
    }

    /**
     * Key {@code publisher.descriptor}: {@code Dropbox Publisher}.
     * 
     * @return
     *     {@code Dropbox Publisher}
     */
    public static Localizable _publisher_descriptor() {
        return new Localizable(holder, "publisher.descriptor");
    }

    /**
     * Key {@code publisherLabel.descriptor}: {@code Dropbox Publisher
     * Label}.
     * 
     * @return
     *     {@code Dropbox Publisher Label}
     */
    public static String publisherLabel_descriptor() {
        return holder.format("publisherLabel.descriptor");
    }

    /**
     * Key {@code publisherLabel.descriptor}: {@code Dropbox Publisher
     * Label}.
     * 
     * @return
     *     {@code Dropbox Publisher Label}
     */
    public static Localizable _publisherLabel_descriptor() {
        return new Localizable(holder, "publisherLabel.descriptor");
    }

    /**
     * Key {@code DropboxTokenImpl.api_token}: {@code Dropbox API token}.
     * 
     * @return
     *     {@code Dropbox API token}
     */
    public static String DropboxTokenImpl_api_token() {
        return holder.format("DropboxTokenImpl.api_token");
    }

    /**
     * Key {@code DropboxTokenImpl.api_token}: {@code Dropbox API token}.
     * 
     * @return
     *     {@code Dropbox API token}
     */
    public static Localizable _DropboxTokenImpl_api_token() {
        return new Localizable(holder, "DropboxTokenImpl.api_token");
    }

    /**
     * Key {@code form.testConnection.ok}: {@code Success}.
     * 
     * @return
     *     {@code Success}
     */
    public static String form_testConnection_ok() {
        return holder.format("form.testConnection.ok");
    }

    /**
     * Key {@code form.testConnection.ok}: {@code Success}.
     * 
     * @return
     *     {@code Success}
     */
    public static Localizable _form_testConnection_ok() {
        return new Localizable(holder, "form.testConnection.ok");
    }

    /**
     * Key {@code exception.bap.transferFile}: {@code Transfer failed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Transfer failed: {0}}
     */
    public static String exception_bap_transferFile(Object arg0) {
        return holder.format("exception.bap.transferFile", arg0);
    }

    /**
     * Key {@code exception.bap.transferFile}: {@code Transfer failed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Transfer failed: {0}}
     */
    public static Localizable _exception_bap_transferFile(Object arg0) {
        return new Localizable(holder, "exception.bap.transferFile", arg0);
    }

    /**
     * Key {@code exception.http}: {@code HTTP {0} error {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code HTTP {0} error {1}}
     */
    public static String exception_http(Object arg0, Object arg1) {
        return holder.format("exception.http", arg0, arg1);
    }

    /**
     * Key {@code exception.http}: {@code HTTP {0} error {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code HTTP {0} error {1}}
     */
    public static Localizable _exception_http(Object arg0, Object arg1) {
        return new Localizable(holder, "exception.http", arg0, arg1);
    }

    /**
     * Key {@code exception.store_chunk_continue}: {@code Failed to upload
     * continue chunk for file ${0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to upload continue chunk for file ${0}}
     */
    public static String exception_store_chunk_continue(Object arg0) {
        return holder.format("exception.store_chunk_continue", arg0);
    }

    /**
     * Key {@code exception.store_chunk_continue}: {@code Failed to upload
     * continue chunk for file ${0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to upload continue chunk for file ${0}}
     */
    public static Localizable _exception_store_chunk_continue(Object arg0) {
        return new Localizable(holder, "exception.store_chunk_continue", arg0);
    }

    /**
     * Key {@code exception.bap.beginTransfers}: {@code Begin transfer
     * failed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Begin transfer failed: {0}}
     */
    public static String exception_bap_beginTransfers(Object arg0) {
        return holder.format("exception.bap.beginTransfers", arg0);
    }

    /**
     * Key {@code exception.bap.beginTransfers}: {@code Begin transfer
     * failed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Begin transfer failed: {0}}
     */
    public static Localizable _exception_bap_beginTransfers(Object arg0) {
        return new Localizable(holder, "exception.bap.beginTransfers", arg0);
    }

    /**
     * Key {@code retry.descriptor}: {@code Dropbox Retry}.
     * 
     * @return
     *     {@code Dropbox Retry}
     */
    public static String retry_descriptor() {
        return holder.format("retry.descriptor");
    }

    /**
     * Key {@code retry.descriptor}: {@code Dropbox Retry}.
     * 
     * @return
     *     {@code Dropbox Retry}
     */
    public static Localizable _retry_descriptor() {
        return new Localizable(holder, "retry.descriptor");
    }

    /**
     * Key {@code exception.rest.connection}: {@code Failed to open
     * connection to server}.
     * 
     * @return
     *     {@code Failed to open connection to server}
     */
    public static String exception_rest_connection() {
        return holder.format("exception.rest.connection");
    }

    /**
     * Key {@code exception.rest.connection}: {@code Failed to open
     * connection to server}.
     * 
     * @return
     *     {@code Failed to open connection to server}
     */
    public static Localizable _exception_rest_connection() {
        return new Localizable(holder, "exception.rest.connection");
    }

    /**
     * Key {@code exception.accesstokens}: {@code Error when retrieving
     * access token from Dropbox}.
     * 
     * @return
     *     {@code Error when retrieving access token from Dropbox}
     */
    public static String exception_accesstokens() {
        return holder.format("exception.accesstokens");
    }

    /**
     * Key {@code exception.accesstokens}: {@code Error when retrieving
     * access token from Dropbox}.
     * 
     * @return
     *     {@code Error when retrieving access token from Dropbox}
     */
    public static Localizable _exception_accesstokens() {
        return new Localizable(holder, "exception.accesstokens");
    }

    /**
     * Key {@code exception.dropbox.folder.delete.root}: {@code Failed to
     * delete, {0} seems to the root folder}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to delete, {0} seems to the root folder}
     */
    public static String exception_dropbox_folder_delete_root(Object arg0) {
        return holder.format("exception.dropbox.folder.delete.root", arg0);
    }

    /**
     * Key {@code exception.dropbox.folder.delete.root}: {@code Failed to
     * delete, {0} seems to the root folder}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to delete, {0} seems to the root folder}
     */
    public static Localizable _exception_dropbox_folder_delete_root(Object arg0) {
        return new Localizable(holder, "exception.dropbox.folder.delete.root", arg0);
    }

    /**
     * Key {@code exception.dropbox.file.upload.simple}: {@code Failed to
     * upload the file, {0} is not uploaded}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to upload the file, {0} is not uploaded}
     */
    public static String exception_dropbox_file_upload_simple(Object arg0) {
        return holder.format("exception.dropbox.file.upload.simple", arg0);
    }

    /**
     * Key {@code exception.dropbox.file.upload.simple}: {@code Failed to
     * upload the file, {0} is not uploaded}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to upload the file, {0} is not uploaded}
     */
    public static Localizable _exception_dropbox_file_upload_simple(Object arg0) {
        return new Localizable(holder, "exception.dropbox.file.upload.simple", arg0);
    }

    /**
     * Key {@code exception.store_chunk_start}: {@code Failed to upload start
     * chunk of file ${0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to upload start chunk of file ${0}}
     */
    public static String exception_store_chunk_start(Object arg0) {
        return holder.format("exception.store_chunk_start", arg0);
    }

    /**
     * Key {@code exception.store_chunk_start}: {@code Failed to upload start
     * chunk of file ${0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to upload start chunk of file ${0}}
     */
    public static Localizable _exception_store_chunk_start(Object arg0) {
        return new Localizable(holder, "exception.store_chunk_start", arg0);
    }

    /**
     * Key {@code exception.dropbox.folder.create}: {@code Failed to create
     * folder {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to create folder {0}}
     */
    public static String exception_dropbox_folder_create(Object arg0) {
        return holder.format("exception.dropbox.folder.create", arg0);
    }

    /**
     * Key {@code exception.dropbox.folder.create}: {@code Failed to create
     * folder {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to create folder {0}}
     */
    public static Localizable _exception_dropbox_folder_create(Object arg0) {
        return new Localizable(holder, "exception.dropbox.folder.create", arg0);
    }

    /**
     * Key {@code exception.dropbox.url}: {@code Failed to build URL to
     * create a connection}.
     * 
     * @return
     *     {@code Failed to build URL to create a connection}
     */
    public static String exception_dropbox_url() {
        return holder.format("exception.dropbox.url");
    }

    /**
     * Key {@code exception.dropbox.url}: {@code Failed to build URL to
     * create a connection}.
     * 
     * @return
     *     {@code Failed to build URL to create a connection}
     */
    public static Localizable _exception_dropbox_url() {
        return new Localizable(holder, "exception.dropbox.url");
    }

    /**
     * Key {@code exception.store_chunk_end}: {@code Failed to upload end
     * chunk for file ${0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to upload end chunk for file ${0}}
     */
    public static String exception_store_chunk_end(Object arg0) {
        return holder.format("exception.store_chunk_end", arg0);
    }

    /**
     * Key {@code exception.store_chunk_end}: {@code Failed to upload end
     * chunk for file ${0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to upload end chunk for file ${0}}
     */
    public static Localizable _exception_store_chunk_end(Object arg0) {
        return new Localizable(holder, "exception.store_chunk_end", arg0);
    }

    /**
     * Key {@code exception.bap.deleteTree}: {@code Delete tree failed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Delete tree failed: {0}}
     */
    public static String exception_bap_deleteTree(Object arg0) {
        return holder.format("exception.bap.deleteTree", arg0);
    }

    /**
     * Key {@code exception.bap.deleteTree}: {@code Delete tree failed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Delete tree failed: {0}}
     */
    public static Localizable _exception_bap_deleteTree(Object arg0) {
        return new Localizable(holder, "exception.bap.deleteTree", arg0);
    }

    /**
     * Key {@code exception.bap.changeDirectory}: {@code Changing directory
     * failed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Changing directory failed: {0}}
     */
    public static String exception_bap_changeDirectory(Object arg0) {
        return holder.format("exception.bap.changeDirectory", arg0);
    }

    /**
     * Key {@code exception.bap.changeDirectory}: {@code Changing directory
     * failed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Changing directory failed: {0}}
     */
    public static Localizable _exception_bap_changeDirectory(Object arg0) {
        return new Localizable(holder, "exception.bap.changeDirectory", arg0);
    }

    /**
     * Key {@code exception.rest.model}: {@code Failed to create response
     * model}.
     * 
     * @return
     *     {@code Failed to create response model}
     */
    public static String exception_rest_model() {
        return holder.format("exception.rest.model");
    }

    /**
     * Key {@code exception.rest.model}: {@code Failed to create response
     * model}.
     * 
     * @return
     *     {@code Failed to create response model}
     */
    public static Localizable _exception_rest_model() {
        return new Localizable(holder, "exception.rest.model");
    }

    /**
     * Key {@code exception.dropbox.file.metadata}: {@code Failed to retrieve
     * data on the file, info on {0} is unknown}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to retrieve data on the file, info on {0} is unknown}
     */
    public static String exception_dropbox_file_metadata(Object arg0) {
        return holder.format("exception.dropbox.file.metadata", arg0);
    }

    /**
     * Key {@code exception.dropbox.file.metadata}: {@code Failed to retrieve
     * data on the file, info on {0} is unknown}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to retrieve data on the file, info on {0} is unknown}
     */
    public static Localizable _exception_dropbox_file_metadata(Object arg0) {
        return new Localizable(holder, "exception.dropbox.file.metadata", arg0);
    }

    /**
     * Key {@code exception.bap.logInFailed}: {@code Failed to log in with
     * username {0} - check username and password}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to log in with username {0} - check username and
     *     password}
     */
    public static String exception_bap_logInFailed(Object arg0) {
        return holder.format("exception.bap.logInFailed", arg0);
    }

    /**
     * Key {@code exception.bap.logInFailed}: {@code Failed to log in with
     * username {0} - check username and password}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to log in with username {0} - check username and
     *     password}
     */
    public static Localizable _exception_bap_logInFailed(Object arg0) {
        return new Localizable(holder, "exception.bap.logInFailed", arg0);
    }

    /**
     * Key {@code exception.preprateTransferFile}: {@code Preparations to
     * transfer "${0}" failed. Could not read}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Preparations to transfer "${0}" failed. Could not read}
     */
    public static String exception_preprateTransferFile(Object arg0) {
        return holder.format("exception.preprateTransferFile", arg0);
    }

    /**
     * Key {@code exception.preprateTransferFile}: {@code Preparations to
     * transfer "${0}" failed. Could not read}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Preparations to transfer "${0}" failed. Could not read}
     */
    public static Localizable _exception_preprateTransferFile(Object arg0) {
        return new Localizable(holder, "exception.preprateTransferFile", arg0);
    }

    /**
     * Key {@code exception.dropbox.folder.prunedate}: {@code Failed to prune
     * a folder, {0} did not parse}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to prune a folder, {0} did not parse}
     */
    public static String exception_dropbox_folder_prunedate(Object arg0) {
        return holder.format("exception.dropbox.folder.prunedate", arg0);
    }

    /**
     * Key {@code exception.dropbox.folder.prunedate}: {@code Failed to prune
     * a folder, {0} did not parse}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to prune a folder, {0} did not parse}
     */
    public static Localizable _exception_dropbox_folder_prunedate(Object arg0) {
        return new Localizable(holder, "exception.dropbox.folder.prunedate", arg0);
    }

    /**
     * Key {@code transfer.descriptor}: {@code Dropbox Transfer}.
     * 
     * @return
     *     {@code Dropbox Transfer}
     */
    public static String transfer_descriptor() {
        return holder.format("transfer.descriptor");
    }

    /**
     * Key {@code transfer.descriptor}: {@code Dropbox Transfer}.
     * 
     * @return
     *     {@code Dropbox Transfer}
     */
    public static Localizable _transfer_descriptor() {
        return new Localizable(holder, "transfer.descriptor");
    }

    /**
     * Key {@code exception.dropbox.folder.list}: {@code Failed to list
     * folder content, {0} was not listed}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to list folder content, {0} was not listed}
     */
    public static String exception_dropbox_folder_list(Object arg0) {
        return holder.format("exception.dropbox.folder.list", arg0);
    }

    /**
     * Key {@code exception.dropbox.folder.list}: {@code Failed to list
     * folder content, {0} was not listed}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to list folder content, {0} was not listed}
     */
    public static Localizable _exception_dropbox_folder_list(Object arg0) {
        return new Localizable(holder, "exception.dropbox.folder.list", arg0);
    }

    /**
     * Key {@code exception.noSourceFiles}: {@code A Transfer Set must
     * contain Source files - if you really want to include everything, set
     * Source files to **<!---->/* or **\*}.
     * 
     * @return
     *     {@code A Transfer Set must contain Source files - if you really want
     *     to include everything, set Source files to **<!---->/* or **\*}
     */
    public static String exception_noSourceFiles() {
        return holder.format("exception.noSourceFiles");
    }

    /**
     * Key {@code exception.noSourceFiles}: {@code A Transfer Set must
     * contain Source files - if you really want to include everything, set
     * Source files to **<!---->/* or **\*}.
     * 
     * @return
     *     {@code A Transfer Set must contain Source files - if you really want
     *     to include everything, set Source files to **<!---->/* or **\*}
     */
    public static Localizable _exception_noSourceFiles() {
        return new Localizable(holder, "exception.noSourceFiles");
    }

    /**
     * Key {@code hostconfig.formvalidation.root}: {@code Remote directory
     * must be an absolute path. (Starting with a '/')}.
     * 
     * @return
     *     {@code Remote directory must be an absolute path. (Starting with a
     *     '/')}
     */
    public static String hostconfig_formvalidation_root() {
        return holder.format("hostconfig.formvalidation.root");
    }

    /**
     * Key {@code hostconfig.formvalidation.root}: {@code Remote directory
     * must be an absolute path. (Starting with a '/')}.
     * 
     * @return
     *     {@code Remote directory must be an absolute path. (Starting with a
     *     '/')}
     */
    public static Localizable _hostconfig_formvalidation_root() {
        return new Localizable(holder, "hostconfig.formvalidation.root");
    }

}
