/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_cifs;

import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jenkins.plugins.publish_over.BapPublisherException;
import jenkins.plugins.publish_over_cifs.Messages;

public class CifsHelper {
    public SmbFile[] listFiles(SmbFile file, String url) {
        try {
            return file.listFiles();
        }
        catch (SmbException smbe) {
            throw new BapPublisherException(Messages.exception_jCifsException_listFiles(this.hideUserInfo(url), smbe.getLocalizedMessage()), (Throwable)smbe);
        }
    }

    public void delete(SmbFile file) {
        try {
            file.delete();
        }
        catch (SmbException smbe) {
            throw new BapPublisherException(Messages.exception_jCifsException_delete(this.hideUserInfo(file.getCanonicalPath()), smbe.getLocalizedMessage()), (Throwable)smbe);
        }
    }

    public boolean exists(SmbFile file, String url) {
        try {
            return file.exists();
        }
        catch (SmbException smbe) {
            throw new BapPublisherException(Messages.exception_jCifsException_exists(this.hideUserInfo(url), smbe.getLocalizedMessage()), (Throwable)smbe);
        }
    }

    public boolean canRead(SmbFile file, String url) {
        try {
            return file.canRead();
        }
        catch (SmbException smbe) {
            throw new BapPublisherException(Messages.exception_jCifsException_canRead(this.hideUserInfo(url), smbe.getLocalizedMessage()), (Throwable)smbe);
        }
    }

    public void mkdirs(SmbFile file, String url) {
        try {
            file.mkdirs();
        }
        catch (SmbException smbe) {
            throw new BapPublisherException(Messages.exception_jCifsException_mkdirs(this.hideUserInfo(url), smbe.getLocalizedMessage()), (Throwable)smbe);
        }
    }

    public String hideUserInfo(String url) {
        if (url.contains("@")) {
            return "smb://******" + url.substring(url.indexOf(64));
        }
        return url;
    }
}

