/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_cifs;

import hudson.Extension;
import hudson.Util;
import hudson.model.Node;
import hudson.model.Run;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPPlugin;
import jenkins.plugins.publish_over.BPPluginDescriptor;
import jenkins.plugins.publish_over.ParamPublish;
import jenkins.plugins.publish_over_cifs.CifsCleanNodeProperties;
import jenkins.plugins.publish_over_cifs.CifsClient;
import jenkins.plugins.publish_over_cifs.CifsHostConfiguration;
import jenkins.plugins.publish_over_cifs.CifsNodeProperties;
import jenkins.plugins.publish_over_cifs.CifsParamPublish;
import jenkins.plugins.publish_over_cifs.CifsPublisher;
import jenkins.plugins.publish_over_cifs.Messages;
import jenkins.plugins.publish_over_cifs.descriptor.CifsPublisherPluginDescriptor;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CifsPublisherPlugin
extends BPPlugin<CifsPublisher, CifsClient, Object> {
    private static final long serialVersionUID = 1L;
    private boolean publishWhenFailed = false;

    public CifsPublisherPlugin(ArrayList<CifsPublisher> publishers, boolean continueOnError, boolean failOnError, boolean alwaysPublishFromMaster, String masterNodeName, CifsParamPublish paramPublish) {
        super(Messages.console_message_prefix(), publishers, continueOnError, failOnError, alwaysPublishFromMaster, masterNodeName, (ParamPublish)paramPublish);
    }

    @DataBoundConstructor
    public CifsPublisherPlugin() {
        super(Messages.console_message_prefix());
    }

    @DataBoundSetter
    public void setPublishWhenFailed(boolean publishWhenFailed) {
        this.publishWhenFailed = publishWhenFailed;
    }

    public boolean getPublishWhenFailed() {
        return this.publishWhenFailed;
    }

    public List<CifsPublisher> getPublishers() {
        return this.getDelegate().getPublishers();
    }

    @DataBoundSetter
    public void setPublishers(ArrayList<CifsPublisher> publishers) {
        this.getDelegate().setPublishers(publishers);
    }

    public boolean isContinueOnError() {
        return this.getDelegate().isContinueOnError();
    }

    @DataBoundSetter
    public void setContinueOnError(boolean continueOnError) {
        this.getDelegate().setContinueOnError(continueOnError);
    }

    public boolean isFailOnError() {
        return this.getDelegate().isFailOnError();
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.getDelegate().setFailOnError(failOnError);
    }

    public boolean isAlwaysPublishFromMaster() {
        return this.getDelegate().isAlwaysPublishFromMaster();
    }

    @DataBoundSetter
    public void setAlwaysPublishFromMaster(boolean alwaysPublishFromMaster) {
        this.getDelegate().setAlwaysPublishFromMaster(alwaysPublishFromMaster);
    }

    public String getMasterNodeName() {
        return this.getDelegate().getMasterNodeName();
    }

    @DataBoundSetter
    public void setMasterNodeName(String masterNodeName) {
        this.getDelegate().setMasterNodeName(masterNodeName);
    }

    public CifsParamPublish getParamPublish() {
        return (CifsParamPublish)this.getDelegate().getParamPublish();
    }

    @DataBoundSetter
    public void setParamPublish(ParamPublish paramPublish) {
        this.getDelegate().setParamPublish(paramPublish);
    }

    protected void fixup(Run<?, ?> build, BPBuildInfo buildInfo) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            CifsNodeProperties defaults = (CifsNodeProperties)jenkins.getGlobalNodeProperties().get(CifsNodeProperties.class);
            if (defaults != null) {
                buildInfo.put("cifs.np.default", (Serializable)this.map(defaults));
            }
            String currNodeName = (String)buildInfo.getCurrentBuildEnv().getEnvVars().get("NODE_NAME");
            this.storeProperties(buildInfo, jenkins, currNodeName, "cifs.np.current");
        }
    }

    private void storeProperties(BPBuildInfo buildInfo, Jenkins jenkins, String nodeName, String contextKey) {
        if (Util.fixEmptyAndTrim((String)nodeName) == null) {
            return;
        }
        Node node = jenkins.getNode(nodeName);
        if (node == null) {
            return;
        }
        CifsNodeProperties currNodeProps = (CifsNodeProperties)node.getNodeProperties().get(CifsNodeProperties.class);
        if (currNodeProps != null) {
            buildInfo.put(contextKey, (Serializable)this.map(currNodeProps));
        }
    }

    private CifsCleanNodeProperties map(CifsNodeProperties nodeProperties) {
        if (nodeProperties == null) {
            return null;
        }
        return new CifsCleanNodeProperties(Util.fixEmptyAndTrim((String)nodeProperties.getWinsServer()));
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || ((Object)((Object)this)).getClass() != that.getClass()) {
            return false;
        }
        return this.addToEquals(new EqualsBuilder(), (CifsPublisherPlugin)((Object)that)).isEquals();
    }

    public int hashCode() {
        return this.addToHashCode(new HashCodeBuilder()).toHashCode();
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }

    public Descriptor getDescriptor() {
        return (Descriptor)Jenkins.get().getDescriptorByType(Descriptor.class);
    }

    public CifsHostConfiguration getConfiguration(String name) {
        return this.getDescriptor().getConfiguration(name);
    }

    protected boolean isBuildGoodEnoughToRun(Run<?, ?> build, PrintStream console) {
        if (this.publishWhenFailed) {
            return true;
        }
        return super.isBuildGoodEnoughToRun(build, console);
    }

    @Extension
    @Symbol(value={"cifsPublisher"})
    public static class Descriptor
    extends CifsPublisherPluginDescriptor {
        @Override
        public Object readResolve() {
            return super.readResolve();
        }
    }

    public static class DescriptorMessages
    implements BPPluginDescriptor.BPDescriptorMessages {
    }
}

