/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors.coverage;

import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.Metric;
import hudson.model.Run;
import io.jenkins.plugins.coverage.metrics.model.Baseline;
import io.prometheus.client.Gauge;
import io.prometheus.client.SimpleCollector;
import java.util.Optional;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;
import org.jenkinsci.plugins.prometheus.collectors.coverage.CoverageMetricsCollector;

public class CoverageFileCoveredGauge
extends CoverageMetricsCollector<Run<?, ?>, Gauge> {
    protected CoverageFileCoveredGauge(String[] labelNames, String namespace, String subsystem) {
        super(labelNames, namespace, subsystem);
    }

    @Override
    protected CollectorType getCollectorType() {
        return CollectorType.COVERAGE_FILE_COVERED;
    }

    @Override
    protected String getHelpText() {
        return "Returns the number of files covered";
    }

    @Override
    protected SimpleCollector.Builder<?, Gauge> getCollectorBuilder() {
        return Gauge.build();
    }

    @Override
    public void calculateMetric(Run<?, ?> jenkinsObject, String[] labelValues) {
        Optional<Coverage> optional = this.getCoverage(jenkinsObject, Metric.FILE, Baseline.PROJECT);
        if (optional.isEmpty()) {
            ((Gauge.Child)((Gauge)this.collector).labels(labelValues)).set(-1.0);
            return;
        }
        Coverage coverage = optional.get();
        ((Gauge.Child)((Gauge)this.collector).labels(labelValues)).set((double)coverage.getCovered());
    }
}

