/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors.jobs;

import hudson.model.Job;
import io.prometheus.client.Collector;
import org.jenkinsci.plugins.prometheus.collectors.BaseCollectorFactory;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;
import org.jenkinsci.plugins.prometheus.collectors.MetricCollector;
import org.jenkinsci.plugins.prometheus.collectors.NoOpMetricCollector;
import org.jenkinsci.plugins.prometheus.collectors.jobs.BuildDiscardGauge;
import org.jenkinsci.plugins.prometheus.collectors.jobs.CurrentRunDurationGauge;
import org.jenkinsci.plugins.prometheus.collectors.jobs.HealthScoreGauge;
import org.jenkinsci.plugins.prometheus.collectors.jobs.LogUpdatedGauge;
import org.jenkinsci.plugins.prometheus.collectors.jobs.NbBuildsGauge;

public class JobCollectorFactory
extends BaseCollectorFactory {
    public MetricCollector<Job<?, ?>, ? extends Collector> createCollector(CollectorType type, String[] labelNames) {
        switch (type) {
            case HEALTH_SCORE_GAUGE: {
                return this.saveBuildCollector(new HealthScoreGauge(labelNames, this.namespace, this.subsystem));
            }
            case NB_BUILDS_GAUGE: {
                return this.saveBuildCollector(new NbBuildsGauge(labelNames, this.namespace, this.subsystem));
            }
            case BUILD_DISCARD_GAUGE: {
                return this.saveBuildCollector(new BuildDiscardGauge(labelNames, this.namespace, this.subsystem));
            }
            case CURRENT_RUN_DURATION_GAUGE: {
                return this.saveBuildCollector(new CurrentRunDurationGauge(labelNames, this.namespace, this.subsystem));
            }
            case JOB_LOG_UPDATED_GAUGE: {
                return this.saveBuildCollector(new LogUpdatedGauge(labelNames, this.namespace, this.subsystem));
            }
        }
        return new NoOpMetricCollector();
    }
}

